/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Information specific to a subscription in canceled state.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CanceledStateContext extends com.google.api.client.json.GenericJson {

  /**
   * Subscription was canceled by the developer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeveloperInitiatedCancellation developerInitiatedCancellation;

  /**
   * Subscription was replaced by a new subscription.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReplacementCancellation replacementCancellation;

  /**
   * Subscription was canceled by the system, for example because of a billing problem.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SystemInitiatedCancellation systemInitiatedCancellation;

  /**
   * Subscription was canceled by user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UserInitiatedCancellation userInitiatedCancellation;

  /**
   * Subscription was canceled by the developer.
   * @return value or {@code null} for none
   */
  public DeveloperInitiatedCancellation getDeveloperInitiatedCancellation() {
    return developerInitiatedCancellation;
  }

  /**
   * Subscription was canceled by the developer.
   * @param developerInitiatedCancellation developerInitiatedCancellation or {@code null} for none
   */
  public CanceledStateContext setDeveloperInitiatedCancellation(DeveloperInitiatedCancellation developerInitiatedCancellation) {
    this.developerInitiatedCancellation = developerInitiatedCancellation;
    return this;
  }

  /**
   * Subscription was replaced by a new subscription.
   * @return value or {@code null} for none
   */
  public ReplacementCancellation getReplacementCancellation() {
    return replacementCancellation;
  }

  /**
   * Subscription was replaced by a new subscription.
   * @param replacementCancellation replacementCancellation or {@code null} for none
   */
  public CanceledStateContext setReplacementCancellation(ReplacementCancellation replacementCancellation) {
    this.replacementCancellation = replacementCancellation;
    return this;
  }

  /**
   * Subscription was canceled by the system, for example because of a billing problem.
   * @return value or {@code null} for none
   */
  public SystemInitiatedCancellation getSystemInitiatedCancellation() {
    return systemInitiatedCancellation;
  }

  /**
   * Subscription was canceled by the system, for example because of a billing problem.
   * @param systemInitiatedCancellation systemInitiatedCancellation or {@code null} for none
   */
  public CanceledStateContext setSystemInitiatedCancellation(SystemInitiatedCancellation systemInitiatedCancellation) {
    this.systemInitiatedCancellation = systemInitiatedCancellation;
    return this;
  }

  /**
   * Subscription was canceled by user.
   * @return value or {@code null} for none
   */
  public UserInitiatedCancellation getUserInitiatedCancellation() {
    return userInitiatedCancellation;
  }

  /**
   * Subscription was canceled by user.
   * @param userInitiatedCancellation userInitiatedCancellation or {@code null} for none
   */
  public CanceledStateContext setUserInitiatedCancellation(UserInitiatedCancellation userInitiatedCancellation) {
    this.userInitiatedCancellation = userInitiatedCancellation;
    return this;
  }

  @Override
  public CanceledStateContext set(String fieldName, Object value) {
    return (CanceledStateContext) super.set(fieldName, value);
  }

  @Override
  public CanceledStateContext clone() {
    return (CanceledStateContext) super.clone();
  }

}
