/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * A release within a track.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TrackRelease extends com.google.api.client.json.GenericJson {

  /**
   * Restricts a release to a specific set of countries.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CountryTargeting countryTargeting;

  /**
   * In-app update priority of the release. All newly added APKs in the release will be considered
   * at this priority. Can take values in the range [0, 5], with 5 the highest priority. Defaults to
   * 0. in_app_update_priority can not be updated once the release is rolled out. See
   * https://developer.android.com/guide/playcore/in-app-updates.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer inAppUpdatePriority;

  /**
   * The release name. Not required to be unique. If not set, the name is generated from the APK's
   * version_name. If the release contains multiple APKs, the name is generated from the date.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * A description of what is new in this release.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<LocalizedText> releaseNotes;

  static {
    // hack to force ProGuard to consider LocalizedText used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(LocalizedText.class);
  }

  /**
   * The status of the release.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * Fraction of users who are eligible for a staged release. 0 < fraction < 1. Can only be set when
   * status is "inProgress" or "halted".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double userFraction;

  /**
   * Version codes of all APKs in the release. Must include version codes to retain from previous
   * releases.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.util.List<java.lang.Long> versionCodes;

  /**
   * Restricts a release to a specific set of countries.
   * @return value or {@code null} for none
   */
  public CountryTargeting getCountryTargeting() {
    return countryTargeting;
  }

  /**
   * Restricts a release to a specific set of countries.
   * @param countryTargeting countryTargeting or {@code null} for none
   */
  public TrackRelease setCountryTargeting(CountryTargeting countryTargeting) {
    this.countryTargeting = countryTargeting;
    return this;
  }

  /**
   * In-app update priority of the release. All newly added APKs in the release will be considered
   * at this priority. Can take values in the range [0, 5], with 5 the highest priority. Defaults to
   * 0. in_app_update_priority can not be updated once the release is rolled out. See
   * https://developer.android.com/guide/playcore/in-app-updates.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getInAppUpdatePriority() {
    return inAppUpdatePriority;
  }

  /**
   * In-app update priority of the release. All newly added APKs in the release will be considered
   * at this priority. Can take values in the range [0, 5], with 5 the highest priority. Defaults to
   * 0. in_app_update_priority can not be updated once the release is rolled out. See
   * https://developer.android.com/guide/playcore/in-app-updates.
   * @param inAppUpdatePriority inAppUpdatePriority or {@code null} for none
   */
  public TrackRelease setInAppUpdatePriority(java.lang.Integer inAppUpdatePriority) {
    this.inAppUpdatePriority = inAppUpdatePriority;
    return this;
  }

  /**
   * The release name. Not required to be unique. If not set, the name is generated from the APK's
   * version_name. If the release contains multiple APKs, the name is generated from the date.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The release name. Not required to be unique. If not set, the name is generated from the APK's
   * version_name. If the release contains multiple APKs, the name is generated from the date.
   * @param name name or {@code null} for none
   */
  public TrackRelease setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * A description of what is new in this release.
   * @return value or {@code null} for none
   */
  public java.util.List<LocalizedText> getReleaseNotes() {
    return releaseNotes;
  }

  /**
   * A description of what is new in this release.
   * @param releaseNotes releaseNotes or {@code null} for none
   */
  public TrackRelease setReleaseNotes(java.util.List<LocalizedText> releaseNotes) {
    this.releaseNotes = releaseNotes;
    return this;
  }

  /**
   * The status of the release.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * The status of the release.
   * @param status status or {@code null} for none
   */
  public TrackRelease setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  /**
   * Fraction of users who are eligible for a staged release. 0 < fraction < 1. Can only be set when
   * status is "inProgress" or "halted".
   * @return value or {@code null} for none
   */
  public java.lang.Double getUserFraction() {
    return userFraction;
  }

  /**
   * Fraction of users who are eligible for a staged release. 0 < fraction < 1. Can only be set when
   * status is "inProgress" or "halted".
   * @param userFraction userFraction or {@code null} for none
   */
  public TrackRelease setUserFraction(java.lang.Double userFraction) {
    this.userFraction = userFraction;
    return this;
  }

  /**
   * Version codes of all APKs in the release. Must include version codes to retain from previous
   * releases.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Long> getVersionCodes() {
    return versionCodes;
  }

  /**
   * Version codes of all APKs in the release. Must include version codes to retain from previous
   * releases.
   * @param versionCodes versionCodes or {@code null} for none
   */
  public TrackRelease setVersionCodes(java.util.List<java.lang.Long> versionCodes) {
    this.versionCodes = versionCodes;
    return this;
  }

  @Override
  public TrackRelease set(String fieldName, Object value) {
    return (TrackRelease) super.set(fieldName, value);
  }

  @Override
  public TrackRelease clone() {
    return (TrackRelease) super.clone();
  }

}
