/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Conditions about a device's RAM capabilities.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DeviceRam extends com.google.api.client.json.GenericJson {

  /**
   * Maximum RAM in bytes (bound excluded).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long maxBytes;

  /**
   * Minimum RAM in bytes (bound included).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long minBytes;

  /**
   * Maximum RAM in bytes (bound excluded).
   * @return value or {@code null} for none
   */
  public java.lang.Long getMaxBytes() {
    return maxBytes;
  }

  /**
   * Maximum RAM in bytes (bound excluded).
   * @param maxBytes maxBytes or {@code null} for none
   */
  public DeviceRam setMaxBytes(java.lang.Long maxBytes) {
    this.maxBytes = maxBytes;
    return this;
  }

  /**
   * Minimum RAM in bytes (bound included).
   * @return value or {@code null} for none
   */
  public java.lang.Long getMinBytes() {
    return minBytes;
  }

  /**
   * Minimum RAM in bytes (bound included).
   * @param minBytes minBytes or {@code null} for none
   */
  public DeviceRam setMinBytes(java.lang.Long minBytes) {
    this.minBytes = minBytes;
    return this;
  }

  @Override
  public DeviceRam set(String fieldName, Object value) {
    return (DeviceRam) super.set(fieldName, value);
  }

  @Override
  public DeviceRam clone() {
    return (DeviceRam) super.clone();
  }

}
