/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Download metadata for a split APK.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GeneratedSplitApk extends com.google.api.client.json.GenericJson {

  /**
   * Download ID, which uniquely identifies the APK to download. Should be supplied to
   * `generatedapks.download` method.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String downloadId;

  /**
   * Name of the module that this APK belongs to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String moduleName;

  /**
   * Split ID. Empty for the main split of the base module.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String splitId;

  /**
   * ID of the generated variant.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer variantId;

  /**
   * Download ID, which uniquely identifies the APK to download. Should be supplied to
   * `generatedapks.download` method.
   * @return value or {@code null} for none
   */
  public java.lang.String getDownloadId() {
    return downloadId;
  }

  /**
   * Download ID, which uniquely identifies the APK to download. Should be supplied to
   * `generatedapks.download` method.
   * @param downloadId downloadId or {@code null} for none
   */
  public GeneratedSplitApk setDownloadId(java.lang.String downloadId) {
    this.downloadId = downloadId;
    return this;
  }

  /**
   * Name of the module that this APK belongs to.
   * @return value or {@code null} for none
   */
  public java.lang.String getModuleName() {
    return moduleName;
  }

  /**
   * Name of the module that this APK belongs to.
   * @param moduleName moduleName or {@code null} for none
   */
  public GeneratedSplitApk setModuleName(java.lang.String moduleName) {
    this.moduleName = moduleName;
    return this;
  }

  /**
   * Split ID. Empty for the main split of the base module.
   * @return value or {@code null} for none
   */
  public java.lang.String getSplitId() {
    return splitId;
  }

  /**
   * Split ID. Empty for the main split of the base module.
   * @param splitId splitId or {@code null} for none
   */
  public GeneratedSplitApk setSplitId(java.lang.String splitId) {
    this.splitId = splitId;
    return this;
  }

  /**
   * ID of the generated variant.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getVariantId() {
    return variantId;
  }

  /**
   * ID of the generated variant.
   * @param variantId variantId or {@code null} for none
   */
  public GeneratedSplitApk setVariantId(java.lang.Integer variantId) {
    this.variantId = variantId;
    return this;
  }

  @Override
  public GeneratedSplitApk set(String fieldName, Object value) {
    return (GeneratedSplitApk) super.set(fieldName, value);
  }

  @Override
  public GeneratedSplitApk clone() {
    return (GeneratedSplitApk) super.clone();
  }

}
