/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Configuration for any new locations Play may launch in for a single offer phase.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OtherRegionsSubscriptionOfferPhaseConfig extends com.google.api.client.json.GenericJson {

  /**
   * The absolute amount of money subtracted from the base plan price prorated over the phase
   * duration that the user pays for this offer phase. For example, if the base plan price for this
   * region is $12 for a period of 1 year, then a $1 absolute discount for a phase of a duration of
   * 3 months would correspond to a price of $2. The resulting price may not be smaller than the
   * minimum price allowed for any new locations Play may launch in.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OtherRegionsSubscriptionOfferPhasePrices absoluteDiscounts;

  /**
   * The absolute price the user pays for this offer phase. The price must not be smaller than the
   * minimum price allowed for any new locations Play may launch in.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OtherRegionsSubscriptionOfferPhasePrices otherRegionsPrices;

  /**
   * The fraction of the base plan price prorated over the phase duration that the user pays for
   * this offer phase. For example, if the base plan price for this region is $12 for a period of 1
   * year, then a 50% discount for a phase of a duration of 3 months would correspond to a price of
   * $1.50. The discount must be specified as a fraction strictly larger than 0 and strictly smaller
   * than 1. The resulting price will be rounded to the nearest billable unit (e.g. cents for USD).
   * The relative discount is considered invalid if the discounted price ends up being smaller than
   * the minimum price allowed in any new locations Play may launch in.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double relativeDiscount;

  /**
   * The absolute amount of money subtracted from the base plan price prorated over the phase
   * duration that the user pays for this offer phase. For example, if the base plan price for this
   * region is $12 for a period of 1 year, then a $1 absolute discount for a phase of a duration of
   * 3 months would correspond to a price of $2. The resulting price may not be smaller than the
   * minimum price allowed for any new locations Play may launch in.
   * @return value or {@code null} for none
   */
  public OtherRegionsSubscriptionOfferPhasePrices getAbsoluteDiscounts() {
    return absoluteDiscounts;
  }

  /**
   * The absolute amount of money subtracted from the base plan price prorated over the phase
   * duration that the user pays for this offer phase. For example, if the base plan price for this
   * region is $12 for a period of 1 year, then a $1 absolute discount for a phase of a duration of
   * 3 months would correspond to a price of $2. The resulting price may not be smaller than the
   * minimum price allowed for any new locations Play may launch in.
   * @param absoluteDiscounts absoluteDiscounts or {@code null} for none
   */
  public OtherRegionsSubscriptionOfferPhaseConfig setAbsoluteDiscounts(OtherRegionsSubscriptionOfferPhasePrices absoluteDiscounts) {
    this.absoluteDiscounts = absoluteDiscounts;
    return this;
  }

  /**
   * The absolute price the user pays for this offer phase. The price must not be smaller than the
   * minimum price allowed for any new locations Play may launch in.
   * @return value or {@code null} for none
   */
  public OtherRegionsSubscriptionOfferPhasePrices getOtherRegionsPrices() {
    return otherRegionsPrices;
  }

  /**
   * The absolute price the user pays for this offer phase. The price must not be smaller than the
   * minimum price allowed for any new locations Play may launch in.
   * @param otherRegionsPrices otherRegionsPrices or {@code null} for none
   */
  public OtherRegionsSubscriptionOfferPhaseConfig setOtherRegionsPrices(OtherRegionsSubscriptionOfferPhasePrices otherRegionsPrices) {
    this.otherRegionsPrices = otherRegionsPrices;
    return this;
  }

  /**
   * The fraction of the base plan price prorated over the phase duration that the user pays for
   * this offer phase. For example, if the base plan price for this region is $12 for a period of 1
   * year, then a 50% discount for a phase of a duration of 3 months would correspond to a price of
   * $1.50. The discount must be specified as a fraction strictly larger than 0 and strictly smaller
   * than 1. The resulting price will be rounded to the nearest billable unit (e.g. cents for USD).
   * The relative discount is considered invalid if the discounted price ends up being smaller than
   * the minimum price allowed in any new locations Play may launch in.
   * @return value or {@code null} for none
   */
  public java.lang.Double getRelativeDiscount() {
    return relativeDiscount;
  }

  /**
   * The fraction of the base plan price prorated over the phase duration that the user pays for
   * this offer phase. For example, if the base plan price for this region is $12 for a period of 1
   * year, then a 50% discount for a phase of a duration of 3 months would correspond to a price of
   * $1.50. The discount must be specified as a fraction strictly larger than 0 and strictly smaller
   * than 1. The resulting price will be rounded to the nearest billable unit (e.g. cents for USD).
   * The relative discount is considered invalid if the discounted price ends up being smaller than
   * the minimum price allowed in any new locations Play may launch in.
   * @param relativeDiscount relativeDiscount or {@code null} for none
   */
  public OtherRegionsSubscriptionOfferPhaseConfig setRelativeDiscount(java.lang.Double relativeDiscount) {
    this.relativeDiscount = relativeDiscount;
    return this;
  }

  @Override
  public OtherRegionsSubscriptionOfferPhaseConfig set(String fieldName, Object value) {
    return (OtherRegionsSubscriptionOfferPhaseConfig) super.set(fieldName, value);
  }

  @Override
  public OtherRegionsSubscriptionOfferPhaseConfig clone() {
    return (OtherRegionsSubscriptionOfferPhaseConfig) super.clone();
  }

}
