/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Represents a base plan that does not automatically renew at the end of the base plan, and must be
 * manually renewed by the user.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PrepaidBasePlanType extends com.google.api.client.json.GenericJson {

  /**
   * Required. Subscription period, specified in ISO 8601 format. For a list of acceptable billing
   * periods, refer to the help center.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String billingPeriodDuration;

  /**
   * Whether users should be able to extend this prepaid base plan in Google Play surfaces. Defaults
   * to TIME_EXTENSION_ACTIVE if not specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String timeExtension;

  /**
   * Required. Subscription period, specified in ISO 8601 format. For a list of acceptable billing
   * periods, refer to the help center.
   * @return value or {@code null} for none
   */
  public java.lang.String getBillingPeriodDuration() {
    return billingPeriodDuration;
  }

  /**
   * Required. Subscription period, specified in ISO 8601 format. For a list of acceptable billing
   * periods, refer to the help center.
   * @param billingPeriodDuration billingPeriodDuration or {@code null} for none
   */
  public PrepaidBasePlanType setBillingPeriodDuration(java.lang.String billingPeriodDuration) {
    this.billingPeriodDuration = billingPeriodDuration;
    return this;
  }

  /**
   * Whether users should be able to extend this prepaid base plan in Google Play surfaces. Defaults
   * to TIME_EXTENSION_ACTIVE if not specified.
   * @return value or {@code null} for none
   */
  public java.lang.String getTimeExtension() {
    return timeExtension;
  }

  /**
   * Whether users should be able to extend this prepaid base plan in Google Play surfaces. Defaults
   * to TIME_EXTENSION_ACTIVE if not specified.
   * @param timeExtension timeExtension or {@code null} for none
   */
  public PrepaidBasePlanType setTimeExtension(java.lang.String timeExtension) {
    this.timeExtension = timeExtension;
    return this;
  }

  @Override
  public PrepaidBasePlanType set(String fieldName, Object value) {
    return (PrepaidBasePlanType) super.set(fieldName, value);
  }

  @Override
  public PrepaidBasePlanType clone() {
    return (PrepaidBasePlanType) super.clone();
  }

}
