/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * A Timestamp represents a point in time independent of any time zone or local calendar, encoded as
 * a count of seconds and fractions of seconds at nanosecond resolution. The count is relative to an
 * epoch at UTC midnight on January 1, 1970.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Timestamp extends com.google.api.client.json.GenericJson {

  /**
   * Non-negative fractions of a second at nanosecond resolution. Must be from 0 to 999,999,999
   * inclusive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer nanos;

  /**
   * Represents seconds of UTC time since Unix epoch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long seconds;

  /**
   * Non-negative fractions of a second at nanosecond resolution. Must be from 0 to 999,999,999
   * inclusive.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getNanos() {
    return nanos;
  }

  /**
   * Non-negative fractions of a second at nanosecond resolution. Must be from 0 to 999,999,999
   * inclusive.
   * @param nanos nanos or {@code null} for none
   */
  public Timestamp setNanos(java.lang.Integer nanos) {
    this.nanos = nanos;
    return this;
  }

  /**
   * Represents seconds of UTC time since Unix epoch.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSeconds() {
    return seconds;
  }

  /**
   * Represents seconds of UTC time since Unix epoch.
   * @param seconds seconds or {@code null} for none
   */
  public Timestamp setSeconds(java.lang.Long seconds) {
    this.seconds = seconds;
    return this;
  }

  @Override
  public Timestamp set(String fieldName, Object value) {
    return (Timestamp) super.set(fieldName, value);
  }

  @Override
  public Timestamp clone() {
    return (Timestamp) super.clone();
  }

}
