/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Information associated with purchases made with 'Subscribe with Google'.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SubscribeWithGoogleInfo extends com.google.api.client.json.GenericJson {

  /**
   * The email address of the user when the subscription was purchased.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String emailAddress;

  /**
   * The family name of the user when the subscription was purchased.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String familyName;

  /**
   * The given name of the user when the subscription was purchased.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String givenName;

  /**
   * The Google profile id of the user when the subscription was purchased.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String profileId;

  /**
   * The profile name of the user when the subscription was purchased.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String profileName;

  /**
   * The email address of the user when the subscription was purchased.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmailAddress() {
    return emailAddress;
  }

  /**
   * The email address of the user when the subscription was purchased.
   * @param emailAddress emailAddress or {@code null} for none
   */
  public SubscribeWithGoogleInfo setEmailAddress(java.lang.String emailAddress) {
    this.emailAddress = emailAddress;
    return this;
  }

  /**
   * The family name of the user when the subscription was purchased.
   * @return value or {@code null} for none
   */
  public java.lang.String getFamilyName() {
    return familyName;
  }

  /**
   * The family name of the user when the subscription was purchased.
   * @param familyName familyName or {@code null} for none
   */
  public SubscribeWithGoogleInfo setFamilyName(java.lang.String familyName) {
    this.familyName = familyName;
    return this;
  }

  /**
   * The given name of the user when the subscription was purchased.
   * @return value or {@code null} for none
   */
  public java.lang.String getGivenName() {
    return givenName;
  }

  /**
   * The given name of the user when the subscription was purchased.
   * @param givenName givenName or {@code null} for none
   */
  public SubscribeWithGoogleInfo setGivenName(java.lang.String givenName) {
    this.givenName = givenName;
    return this;
  }

  /**
   * The Google profile id of the user when the subscription was purchased.
   * @return value or {@code null} for none
   */
  public java.lang.String getProfileId() {
    return profileId;
  }

  /**
   * The Google profile id of the user when the subscription was purchased.
   * @param profileId profileId or {@code null} for none
   */
  public SubscribeWithGoogleInfo setProfileId(java.lang.String profileId) {
    this.profileId = profileId;
    return this;
  }

  /**
   * The profile name of the user when the subscription was purchased.
   * @return value or {@code null} for none
   */
  public java.lang.String getProfileName() {
    return profileName;
  }

  /**
   * The profile name of the user when the subscription was purchased.
   * @param profileName profileName or {@code null} for none
   */
  public SubscribeWithGoogleInfo setProfileName(java.lang.String profileName) {
    this.profileName = profileName;
    return this;
  }

  @Override
  public SubscribeWithGoogleInfo set(String fieldName, Object value) {
    return (SubscribeWithGoogleInfo) super.set(fieldName, value);
  }

  @Override
  public SubscribeWithGoogleInfo clone() {
    return (SubscribeWithGoogleInfo) super.clone();
  }

}
