/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Represents a targeting rule of the form: User never had {scope} before.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AcquisitionTargetingRule extends com.google.api.client.json.GenericJson {

  /**
   * Required. The scope of subscriptions this rule considers. Only allows "this subscription" and
   * "any subscription in app".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TargetingRuleScope scope;

  /**
   * Required. The scope of subscriptions this rule considers. Only allows "this subscription" and
   * "any subscription in app".
   * @return value or {@code null} for none
   */
  public TargetingRuleScope getScope() {
    return scope;
  }

  /**
   * Required. The scope of subscriptions this rule considers. Only allows "this subscription" and
   * "any subscription in app".
   * @param scope scope or {@code null} for none
   */
  public AcquisitionTargetingRule setScope(TargetingRuleScope scope) {
    this.scope = scope;
    return this;
  }

  @Override
  public AcquisitionTargetingRule set(String fieldName, Object value) {
    return (AcquisitionTargetingRule) super.set(fieldName, value);
  }

  @Override
  public AcquisitionTargetingRule clone() {
    return (AcquisitionTargetingRule) super.clone();
  }

}
