/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * An app edit. The resource for EditsService.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AppEdit extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The time (as seconds since Epoch) at which the edit will expire and will be no
   * longer valid for use.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String expiryTimeSeconds;

  /**
   * Output only. Identifier of the edit. Can be used in subsequent API calls.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Output only. The time (as seconds since Epoch) at which the edit will expire and will be no
   * longer valid for use.
   * @return value or {@code null} for none
   */
  public java.lang.String getExpiryTimeSeconds() {
    return expiryTimeSeconds;
  }

  /**
   * Output only. The time (as seconds since Epoch) at which the edit will expire and will be no
   * longer valid for use.
   * @param expiryTimeSeconds expiryTimeSeconds or {@code null} for none
   */
  public AppEdit setExpiryTimeSeconds(java.lang.String expiryTimeSeconds) {
    this.expiryTimeSeconds = expiryTimeSeconds;
    return this;
  }

  /**
   * Output only. Identifier of the edit. Can be used in subsequent API calls.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Output only. Identifier of the edit. Can be used in subsequent API calls.
   * @param id id or {@code null} for none
   */
  public AppEdit setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  @Override
  public AppEdit set(String fieldName, Object value) {
    return (AppEdit) super.set(fieldName, value);
  }

  @Override
  public AppEdit clone() {
    return (AppEdit) super.clone();
  }

}
