/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Download metadata for split, standalone and universal APKs, as well as asset pack slices, signed
 * with a given key.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GeneratedApksPerSigningKey extends com.google.api.client.json.GenericJson {

  /**
   * SHA256 hash of the APK signing public key certificate.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String certificateSha256Hash;

  /**
   * List of asset pack slices which will be served for this app bundle, signed with a key
   * corresponding to certificate_sha256_hash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GeneratedAssetPackSlice> generatedAssetPackSlices;

  /**
   * List of generated split APKs, signed with a key corresponding to certificate_sha256_hash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GeneratedSplitApk> generatedSplitApks;

  /**
   * List of generated standalone APKs, signed with a key corresponding to certificate_sha256_hash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GeneratedStandaloneApk> generatedStandaloneApks;

  /**
   * Generated universal APK, signed with a key corresponding to certificate_sha256_hash. This field
   * is not set if no universal APK was generated for this signing key.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GeneratedUniversalApk generatedUniversalApk;

  /**
   * Contains targeting information about the generated apks.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TargetingInfo targetingInfo;

  /**
   * SHA256 hash of the APK signing public key certificate.
   * @return value or {@code null} for none
   */
  public java.lang.String getCertificateSha256Hash() {
    return certificateSha256Hash;
  }

  /**
   * SHA256 hash of the APK signing public key certificate.
   * @param certificateSha256Hash certificateSha256Hash or {@code null} for none
   */
  public GeneratedApksPerSigningKey setCertificateSha256Hash(java.lang.String certificateSha256Hash) {
    this.certificateSha256Hash = certificateSha256Hash;
    return this;
  }

  /**
   * List of asset pack slices which will be served for this app bundle, signed with a key
   * corresponding to certificate_sha256_hash.
   * @return value or {@code null} for none
   */
  public java.util.List<GeneratedAssetPackSlice> getGeneratedAssetPackSlices() {
    return generatedAssetPackSlices;
  }

  /**
   * List of asset pack slices which will be served for this app bundle, signed with a key
   * corresponding to certificate_sha256_hash.
   * @param generatedAssetPackSlices generatedAssetPackSlices or {@code null} for none
   */
  public GeneratedApksPerSigningKey setGeneratedAssetPackSlices(java.util.List<GeneratedAssetPackSlice> generatedAssetPackSlices) {
    this.generatedAssetPackSlices = generatedAssetPackSlices;
    return this;
  }

  /**
   * List of generated split APKs, signed with a key corresponding to certificate_sha256_hash.
   * @return value or {@code null} for none
   */
  public java.util.List<GeneratedSplitApk> getGeneratedSplitApks() {
    return generatedSplitApks;
  }

  /**
   * List of generated split APKs, signed with a key corresponding to certificate_sha256_hash.
   * @param generatedSplitApks generatedSplitApks or {@code null} for none
   */
  public GeneratedApksPerSigningKey setGeneratedSplitApks(java.util.List<GeneratedSplitApk> generatedSplitApks) {
    this.generatedSplitApks = generatedSplitApks;
    return this;
  }

  /**
   * List of generated standalone APKs, signed with a key corresponding to certificate_sha256_hash.
   * @return value or {@code null} for none
   */
  public java.util.List<GeneratedStandaloneApk> getGeneratedStandaloneApks() {
    return generatedStandaloneApks;
  }

  /**
   * List of generated standalone APKs, signed with a key corresponding to certificate_sha256_hash.
   * @param generatedStandaloneApks generatedStandaloneApks or {@code null} for none
   */
  public GeneratedApksPerSigningKey setGeneratedStandaloneApks(java.util.List<GeneratedStandaloneApk> generatedStandaloneApks) {
    this.generatedStandaloneApks = generatedStandaloneApks;
    return this;
  }

  /**
   * Generated universal APK, signed with a key corresponding to certificate_sha256_hash. This field
   * is not set if no universal APK was generated for this signing key.
   * @return value or {@code null} for none
   */
  public GeneratedUniversalApk getGeneratedUniversalApk() {
    return generatedUniversalApk;
  }

  /**
   * Generated universal APK, signed with a key corresponding to certificate_sha256_hash. This field
   * is not set if no universal APK was generated for this signing key.
   * @param generatedUniversalApk generatedUniversalApk or {@code null} for none
   */
  public GeneratedApksPerSigningKey setGeneratedUniversalApk(GeneratedUniversalApk generatedUniversalApk) {
    this.generatedUniversalApk = generatedUniversalApk;
    return this;
  }

  /**
   * Contains targeting information about the generated apks.
   * @return value or {@code null} for none
   */
  public TargetingInfo getTargetingInfo() {
    return targetingInfo;
  }

  /**
   * Contains targeting information about the generated apks.
   * @param targetingInfo targetingInfo or {@code null} for none
   */
  public GeneratedApksPerSigningKey setTargetingInfo(TargetingInfo targetingInfo) {
    this.targetingInfo = targetingInfo;
    return this;
  }

  @Override
  public GeneratedApksPerSigningKey set(String fieldName, Object value) {
    return (GeneratedApksPerSigningKey) super.set(fieldName, value);
  }

  @Override
  public GeneratedApksPerSigningKey clone() {
    return (GeneratedApksPerSigningKey) super.clone();
  }

}
