/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Specified details about taxation in a given geographical region.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RegionalTaxRateInfo extends com.google.api.client.json.GenericJson {

  /**
   * You must tell us if your app contains streaming products to correctly charge US state and local
   * sales tax. Field only supported in United States.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean eligibleForStreamingServiceTaxRate;

  /**
   * To collect communications or amusement taxes in the United States, choose the appropriate tax
   * category. [Learn more](https://support.google.com/googleplay/android-
   * developer/answer/10463498#streaming_tax).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String streamingTaxType;

  /**
   * Tax tier to specify reduced tax rate. Developers who sell digital news, magazines, newspapers,
   * books, or audiobooks in various regions may be eligible for reduced tax rates. [Learn
   * more](https://support.google.com/googleplay/android-developer/answer/10463498).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String taxTier;

  /**
   * You must tell us if your app contains streaming products to correctly charge US state and local
   * sales tax. Field only supported in United States.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEligibleForStreamingServiceTaxRate() {
    return eligibleForStreamingServiceTaxRate;
  }

  /**
   * You must tell us if your app contains streaming products to correctly charge US state and local
   * sales tax. Field only supported in United States.
   * @param eligibleForStreamingServiceTaxRate eligibleForStreamingServiceTaxRate or {@code null} for none
   */
  public RegionalTaxRateInfo setEligibleForStreamingServiceTaxRate(java.lang.Boolean eligibleForStreamingServiceTaxRate) {
    this.eligibleForStreamingServiceTaxRate = eligibleForStreamingServiceTaxRate;
    return this;
  }

  /**
   * To collect communications or amusement taxes in the United States, choose the appropriate tax
   * category. [Learn more](https://support.google.com/googleplay/android-
   * developer/answer/10463498#streaming_tax).
   * @return value or {@code null} for none
   */
  public java.lang.String getStreamingTaxType() {
    return streamingTaxType;
  }

  /**
   * To collect communications or amusement taxes in the United States, choose the appropriate tax
   * category. [Learn more](https://support.google.com/googleplay/android-
   * developer/answer/10463498#streaming_tax).
   * @param streamingTaxType streamingTaxType or {@code null} for none
   */
  public RegionalTaxRateInfo setStreamingTaxType(java.lang.String streamingTaxType) {
    this.streamingTaxType = streamingTaxType;
    return this;
  }

  /**
   * Tax tier to specify reduced tax rate. Developers who sell digital news, magazines, newspapers,
   * books, or audiobooks in various regions may be eligible for reduced tax rates. [Learn
   * more](https://support.google.com/googleplay/android-developer/answer/10463498).
   * @return value or {@code null} for none
   */
  public java.lang.String getTaxTier() {
    return taxTier;
  }

  /**
   * Tax tier to specify reduced tax rate. Developers who sell digital news, magazines, newspapers,
   * books, or audiobooks in various regions may be eligible for reduced tax rates. [Learn
   * more](https://support.google.com/googleplay/android-developer/answer/10463498).
   * @param taxTier taxTier or {@code null} for none
   */
  public RegionalTaxRateInfo setTaxTier(java.lang.String taxTier) {
    this.taxTier = taxTier;
    return this;
  }

  @Override
  public RegionalTaxRateInfo set(String fieldName, Object value) {
    return (RegionalTaxRateInfo) super.set(fieldName, value);
  }

  @Override
  public RegionalTaxRateInfo clone() {
    return (RegionalTaxRateInfo) super.clone();
  }

}
