/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * A single subscription for an app.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Subscription extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Whether this subscription is archived. Archived subscriptions are not available to
   * any subscriber any longer, cannot be updated, and are not returned in list requests unless the
   * show archived flag is passed in.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean archived;

  /**
   * The set of base plans for this subscription. Represents the prices and duration of the
   * subscription if no other offers apply.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<BasePlan> basePlans;

  static {
    // hack to force ProGuard to consider BasePlan used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(BasePlan.class);
  }

  /**
   * Required. List of localized listings for this subscription. Must contain at least an entry for
   * the default language of the parent app.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<SubscriptionListing> listings;

  /**
   * Immutable. Package name of the parent app.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String packageName;

  /**
   * Immutable. Unique product ID of the product. Unique within the parent app. Product IDs must be
   * composed of lower-case letters (a-z), numbers (0-9), underscores (_) and dots (.). It must
   * start with a lower-case letter or number, and be between 1 and 40 (inclusive) characters in
   * length.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String productId;

  /**
   * Details about taxes and legal compliance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SubscriptionTaxAndComplianceSettings taxAndComplianceSettings;

  /**
   * Output only. Whether this subscription is archived. Archived subscriptions are not available to
   * any subscriber any longer, cannot be updated, and are not returned in list requests unless the
   * show archived flag is passed in.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getArchived() {
    return archived;
  }

  /**
   * Output only. Whether this subscription is archived. Archived subscriptions are not available to
   * any subscriber any longer, cannot be updated, and are not returned in list requests unless the
   * show archived flag is passed in.
   * @param archived archived or {@code null} for none
   */
  public Subscription setArchived(java.lang.Boolean archived) {
    this.archived = archived;
    return this;
  }

  /**
   * The set of base plans for this subscription. Represents the prices and duration of the
   * subscription if no other offers apply.
   * @return value or {@code null} for none
   */
  public java.util.List<BasePlan> getBasePlans() {
    return basePlans;
  }

  /**
   * The set of base plans for this subscription. Represents the prices and duration of the
   * subscription if no other offers apply.
   * @param basePlans basePlans or {@code null} for none
   */
  public Subscription setBasePlans(java.util.List<BasePlan> basePlans) {
    this.basePlans = basePlans;
    return this;
  }

  /**
   * Required. List of localized listings for this subscription. Must contain at least an entry for
   * the default language of the parent app.
   * @return value or {@code null} for none
   */
  public java.util.List<SubscriptionListing> getListings() {
    return listings;
  }

  /**
   * Required. List of localized listings for this subscription. Must contain at least an entry for
   * the default language of the parent app.
   * @param listings listings or {@code null} for none
   */
  public Subscription setListings(java.util.List<SubscriptionListing> listings) {
    this.listings = listings;
    return this;
  }

  /**
   * Immutable. Package name of the parent app.
   * @return value or {@code null} for none
   */
  public java.lang.String getPackageName() {
    return packageName;
  }

  /**
   * Immutable. Package name of the parent app.
   * @param packageName packageName or {@code null} for none
   */
  public Subscription setPackageName(java.lang.String packageName) {
    this.packageName = packageName;
    return this;
  }

  /**
   * Immutable. Unique product ID of the product. Unique within the parent app. Product IDs must be
   * composed of lower-case letters (a-z), numbers (0-9), underscores (_) and dots (.). It must
   * start with a lower-case letter or number, and be between 1 and 40 (inclusive) characters in
   * length.
   * @return value or {@code null} for none
   */
  public java.lang.String getProductId() {
    return productId;
  }

  /**
   * Immutable. Unique product ID of the product. Unique within the parent app. Product IDs must be
   * composed of lower-case letters (a-z), numbers (0-9), underscores (_) and dots (.). It must
   * start with a lower-case letter or number, and be between 1 and 40 (inclusive) characters in
   * length.
   * @param productId productId or {@code null} for none
   */
  public Subscription setProductId(java.lang.String productId) {
    this.productId = productId;
    return this;
  }

  /**
   * Details about taxes and legal compliance.
   * @return value or {@code null} for none
   */
  public SubscriptionTaxAndComplianceSettings getTaxAndComplianceSettings() {
    return taxAndComplianceSettings;
  }

  /**
   * Details about taxes and legal compliance.
   * @param taxAndComplianceSettings taxAndComplianceSettings or {@code null} for none
   */
  public Subscription setTaxAndComplianceSettings(SubscriptionTaxAndComplianceSettings taxAndComplianceSettings) {
    this.taxAndComplianceSettings = taxAndComplianceSettings;
    return this;
  }

  @Override
  public Subscription set(String fieldName, Object value) {
    return (Subscription) super.set(fieldName, value);
  }

  @Override
  public Subscription clone() {
    return (Subscription) super.clone();
  }

}
