/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * A group of devices. A group is defined by a set of device selectors. A device belongs to the
 * group if it matches any selector (logical OR).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DeviceGroup extends com.google.api.client.json.GenericJson {

  /**
   * Device selectors for this group. A device matching any of the selectors is included in this
   * group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DeviceSelector> deviceSelectors;

  /**
   * The name of the group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Device selectors for this group. A device matching any of the selectors is included in this
   * group.
   * @return value or {@code null} for none
   */
  public java.util.List<DeviceSelector> getDeviceSelectors() {
    return deviceSelectors;
  }

  /**
   * Device selectors for this group. A device matching any of the selectors is included in this
   * group.
   * @param deviceSelectors deviceSelectors or {@code null} for none
   */
  public DeviceGroup setDeviceSelectors(java.util.List<DeviceSelector> deviceSelectors) {
    this.deviceSelectors = deviceSelectors;
    return this;
  }

  /**
   * The name of the group.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the group.
   * @param name name or {@code null} for none
   */
  public DeviceGroup setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public DeviceGroup set(String fieldName, Object value) {
    return (DeviceGroup) super.set(fieldName, value);
  }

  @Override
  public DeviceGroup clone() {
    return (DeviceGroup) super.clone();
  }

}
