/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * A single phase of a subscription offer.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SubscriptionOfferPhase extends com.google.api.client.json.GenericJson {

  /**
   * Required. The duration of a single recurrence of this phase. Specified in ISO 8601 format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String duration;

  /**
   * Pricing information for any new locations Play may launch in.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OtherRegionsSubscriptionOfferPhaseConfig otherRegionsConfig;

  /**
   * Required. The number of times this phase repeats. If this offer phase is not free, each
   * recurrence charges the user the price of this offer phase.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer recurrenceCount;

  /**
   * Required. The region-specific configuration of this offer phase. This list must contain exactly
   * one entry for each region for which the subscription offer has a regional config.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<RegionalSubscriptionOfferPhaseConfig> regionalConfigs;

  static {
    // hack to force ProGuard to consider RegionalSubscriptionOfferPhaseConfig used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(RegionalSubscriptionOfferPhaseConfig.class);
  }

  /**
   * Required. The duration of a single recurrence of this phase. Specified in ISO 8601 format.
   * @return value or {@code null} for none
   */
  public java.lang.String getDuration() {
    return duration;
  }

  /**
   * Required. The duration of a single recurrence of this phase. Specified in ISO 8601 format.
   * @param duration duration or {@code null} for none
   */
  public SubscriptionOfferPhase setDuration(java.lang.String duration) {
    this.duration = duration;
    return this;
  }

  /**
   * Pricing information for any new locations Play may launch in.
   * @return value or {@code null} for none
   */
  public OtherRegionsSubscriptionOfferPhaseConfig getOtherRegionsConfig() {
    return otherRegionsConfig;
  }

  /**
   * Pricing information for any new locations Play may launch in.
   * @param otherRegionsConfig otherRegionsConfig or {@code null} for none
   */
  public SubscriptionOfferPhase setOtherRegionsConfig(OtherRegionsSubscriptionOfferPhaseConfig otherRegionsConfig) {
    this.otherRegionsConfig = otherRegionsConfig;
    return this;
  }

  /**
   * Required. The number of times this phase repeats. If this offer phase is not free, each
   * recurrence charges the user the price of this offer phase.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getRecurrenceCount() {
    return recurrenceCount;
  }

  /**
   * Required. The number of times this phase repeats. If this offer phase is not free, each
   * recurrence charges the user the price of this offer phase.
   * @param recurrenceCount recurrenceCount or {@code null} for none
   */
  public SubscriptionOfferPhase setRecurrenceCount(java.lang.Integer recurrenceCount) {
    this.recurrenceCount = recurrenceCount;
    return this;
  }

  /**
   * Required. The region-specific configuration of this offer phase. This list must contain exactly
   * one entry for each region for which the subscription offer has a regional config.
   * @return value or {@code null} for none
   */
  public java.util.List<RegionalSubscriptionOfferPhaseConfig> getRegionalConfigs() {
    return regionalConfigs;
  }

  /**
   * Required. The region-specific configuration of this offer phase. This list must contain exactly
   * one entry for each region for which the subscription offer has a regional config.
   * @param regionalConfigs regionalConfigs or {@code null} for none
   */
  public SubscriptionOfferPhase setRegionalConfigs(java.util.List<RegionalSubscriptionOfferPhaseConfig> regionalConfigs) {
    this.regionalConfigs = regionalConfigs;
    return this;
  }

  @Override
  public SubscriptionOfferPhase set(String fieldName, Object value) {
    return (SubscriptionOfferPhase) super.set(fieldName, value);
  }

  @Override
  public SubscriptionOfferPhase clone() {
    return (SubscriptionOfferPhase) super.clone();
  }

}
