/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Defines the rule a user needs to satisfy to receive this offer.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SubscriptionOfferTargeting extends com.google.api.client.json.GenericJson {

  /**
   * Offer targeting rule for new user acquisition.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AcquisitionTargetingRule acquisitionRule;

  /**
   * Offer targeting rule for upgrading users' existing plans.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpgradeTargetingRule upgradeRule;

  /**
   * Offer targeting rule for new user acquisition.
   * @return value or {@code null} for none
   */
  public AcquisitionTargetingRule getAcquisitionRule() {
    return acquisitionRule;
  }

  /**
   * Offer targeting rule for new user acquisition.
   * @param acquisitionRule acquisitionRule or {@code null} for none
   */
  public SubscriptionOfferTargeting setAcquisitionRule(AcquisitionTargetingRule acquisitionRule) {
    this.acquisitionRule = acquisitionRule;
    return this;
  }

  /**
   * Offer targeting rule for upgrading users' existing plans.
   * @return value or {@code null} for none
   */
  public UpgradeTargetingRule getUpgradeRule() {
    return upgradeRule;
  }

  /**
   * Offer targeting rule for upgrading users' existing plans.
   * @param upgradeRule upgradeRule or {@code null} for none
   */
  public SubscriptionOfferTargeting setUpgradeRule(UpgradeTargetingRule upgradeRule) {
    this.upgradeRule = upgradeRule;
    return this;
  }

  @Override
  public SubscriptionOfferTargeting set(String fieldName, Object value) {
    return (SubscriptionOfferTargeting) super.set(fieldName, value);
  }

  @Override
  public SubscriptionOfferTargeting clone() {
    return (SubscriptionOfferTargeting) super.clone();
  }

}
