/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Description of the created apks.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ApkDescription extends com.google.api.client.json.GenericJson {

  /**
   * Set only for asset slices.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SplitApkMetadata assetSliceMetadata;

  /**
   * Set only for Instant split APKs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SplitApkMetadata instantApkMetadata;

  /**
   * Path of the Apk, will be in the following format: .apk where DownloadId is the ID used to
   * download the apk using GeneratedApks.Download API.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String path;

  /**
   * Set only for Split APKs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SplitApkMetadata splitApkMetadata;

  /**
   * Set only for standalone APKs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private StandaloneApkMetadata standaloneApkMetadata;

  /**
   * Apk-level targeting.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ApkTargeting targeting;

  /**
   * Set only for asset slices.
   * @return value or {@code null} for none
   */
  public SplitApkMetadata getAssetSliceMetadata() {
    return assetSliceMetadata;
  }

  /**
   * Set only for asset slices.
   * @param assetSliceMetadata assetSliceMetadata or {@code null} for none
   */
  public ApkDescription setAssetSliceMetadata(SplitApkMetadata assetSliceMetadata) {
    this.assetSliceMetadata = assetSliceMetadata;
    return this;
  }

  /**
   * Set only for Instant split APKs.
   * @return value or {@code null} for none
   */
  public SplitApkMetadata getInstantApkMetadata() {
    return instantApkMetadata;
  }

  /**
   * Set only for Instant split APKs.
   * @param instantApkMetadata instantApkMetadata or {@code null} for none
   */
  public ApkDescription setInstantApkMetadata(SplitApkMetadata instantApkMetadata) {
    this.instantApkMetadata = instantApkMetadata;
    return this;
  }

  /**
   * Path of the Apk, will be in the following format: .apk where DownloadId is the ID used to
   * download the apk using GeneratedApks.Download API.
   * @return value or {@code null} for none
   */
  public java.lang.String getPath() {
    return path;
  }

  /**
   * Path of the Apk, will be in the following format: .apk where DownloadId is the ID used to
   * download the apk using GeneratedApks.Download API.
   * @param path path or {@code null} for none
   */
  public ApkDescription setPath(java.lang.String path) {
    this.path = path;
    return this;
  }

  /**
   * Set only for Split APKs.
   * @return value or {@code null} for none
   */
  public SplitApkMetadata getSplitApkMetadata() {
    return splitApkMetadata;
  }

  /**
   * Set only for Split APKs.
   * @param splitApkMetadata splitApkMetadata or {@code null} for none
   */
  public ApkDescription setSplitApkMetadata(SplitApkMetadata splitApkMetadata) {
    this.splitApkMetadata = splitApkMetadata;
    return this;
  }

  /**
   * Set only for standalone APKs.
   * @return value or {@code null} for none
   */
  public StandaloneApkMetadata getStandaloneApkMetadata() {
    return standaloneApkMetadata;
  }

  /**
   * Set only for standalone APKs.
   * @param standaloneApkMetadata standaloneApkMetadata or {@code null} for none
   */
  public ApkDescription setStandaloneApkMetadata(StandaloneApkMetadata standaloneApkMetadata) {
    this.standaloneApkMetadata = standaloneApkMetadata;
    return this;
  }

  /**
   * Apk-level targeting.
   * @return value or {@code null} for none
   */
  public ApkTargeting getTargeting() {
    return targeting;
  }

  /**
   * Apk-level targeting.
   * @param targeting targeting or {@code null} for none
   */
  public ApkDescription setTargeting(ApkTargeting targeting) {
    this.targeting = targeting;
    return this;
  }

  @Override
  public ApkDescription set(String fieldName, Object value) {
    return (ApkDescription) super.set(fieldName, value);
  }

  @Override
  public ApkDescription clone() {
    return (ApkDescription) super.clone();
  }

}
