/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Revocation context of the purchases.subscriptionsv2.revoke API.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RevocationContext extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Used when users should be refunded a prorated amount they paid for their subscription
   * based on the amount of time remaining in a subscription. Not supported for subscriptions with
   * multiple items.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RevocationContextProratedRefund proratedRefund;

  /**
   * Optional. Used when users should be refunded a prorated amount they paid for their subscription
   * based on the amount of time remaining in a subscription. Not supported for subscriptions with
   * multiple items.
   * @return value or {@code null} for none
   */
  public RevocationContextProratedRefund getProratedRefund() {
    return proratedRefund;
  }

  /**
   * Optional. Used when users should be refunded a prorated amount they paid for their subscription
   * based on the amount of time remaining in a subscription. Not supported for subscriptions with
   * multiple items.
   * @param proratedRefund proratedRefund or {@code null} for none
   */
  public RevocationContext setProratedRefund(RevocationContextProratedRefund proratedRefund) {
    this.proratedRefund = proratedRefund;
    return this;
  }

  @Override
  public RevocationContext set(String fieldName, Object value) {
    return (RevocationContext) super.set(fieldName, value);
  }

  @Override
  public RevocationContext clone() {
    return (RevocationContext) super.clone();
  }

}
