/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * The details of an external transaction.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ExternalTransaction extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The time when this transaction was created. This is the time when Google was
   * notified of the transaction.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * Output only. The current transaction amount before tax. This represents the current pre-tax
   * amount including any refunds that may have been applied to this transaction.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price currentPreTaxAmount;

  /**
   * Output only. The current tax amount. This represents the current tax amount including any
   * refunds that may have been applied to this transaction.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price currentTaxAmount;

  /**
   * Output only. The id of this transaction. All transaction ids under the same package name must
   * be unique. Set when creating the external transaction.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String externalTransactionId;

  /**
   * This is a one-time transaction and not part of a subscription.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OneTimeExternalTransaction oneTimeTransaction;

  /**
   * Required. The original transaction amount before taxes. This represents the pre-tax amount
   * originally notified to Google before any refunds were applied.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price originalPreTaxAmount;

  /**
   * Required. The original tax amount. This represents the tax amount originally notified to Google
   * before any refunds were applied.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price originalTaxAmount;

  /**
   * Output only. The resource name of the external transaction. The package name of the application
   * the inapp products were sold (for example, 'com.some.app').
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String packageName;

  /**
   * This transaction is part of a recurring series of transactions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RecurringExternalTransaction recurringTransaction;

  /**
   * Output only. If set, this transaction was a test purchase. Google will not charge for a test
   * transaction.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ExternalTransactionTestPurchase testPurchase;

  /**
   * Output only. The current state of the transaction.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String transactionState;

  /**
   * Required. The time when the transaction was completed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String transactionTime;

  /**
   * Required. User address for tax computation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ExternalTransactionAddress userTaxAddress;

  /**
   * Output only. The time when this transaction was created. This is the time when Google was
   * notified of the transaction.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * Output only. The time when this transaction was created. This is the time when Google was
   * notified of the transaction.
   * @param createTime createTime or {@code null} for none
   */
  public ExternalTransaction setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * Output only. The current transaction amount before tax. This represents the current pre-tax
   * amount including any refunds that may have been applied to this transaction.
   * @return value or {@code null} for none
   */
  public Price getCurrentPreTaxAmount() {
    return currentPreTaxAmount;
  }

  /**
   * Output only. The current transaction amount before tax. This represents the current pre-tax
   * amount including any refunds that may have been applied to this transaction.
   * @param currentPreTaxAmount currentPreTaxAmount or {@code null} for none
   */
  public ExternalTransaction setCurrentPreTaxAmount(Price currentPreTaxAmount) {
    this.currentPreTaxAmount = currentPreTaxAmount;
    return this;
  }

  /**
   * Output only. The current tax amount. This represents the current tax amount including any
   * refunds that may have been applied to this transaction.
   * @return value or {@code null} for none
   */
  public Price getCurrentTaxAmount() {
    return currentTaxAmount;
  }

  /**
   * Output only. The current tax amount. This represents the current tax amount including any
   * refunds that may have been applied to this transaction.
   * @param currentTaxAmount currentTaxAmount or {@code null} for none
   */
  public ExternalTransaction setCurrentTaxAmount(Price currentTaxAmount) {
    this.currentTaxAmount = currentTaxAmount;
    return this;
  }

  /**
   * Output only. The id of this transaction. All transaction ids under the same package name must
   * be unique. Set when creating the external transaction.
   * @return value or {@code null} for none
   */
  public java.lang.String getExternalTransactionId() {
    return externalTransactionId;
  }

  /**
   * Output only. The id of this transaction. All transaction ids under the same package name must
   * be unique. Set when creating the external transaction.
   * @param externalTransactionId externalTransactionId or {@code null} for none
   */
  public ExternalTransaction setExternalTransactionId(java.lang.String externalTransactionId) {
    this.externalTransactionId = externalTransactionId;
    return this;
  }

  /**
   * This is a one-time transaction and not part of a subscription.
   * @return value or {@code null} for none
   */
  public OneTimeExternalTransaction getOneTimeTransaction() {
    return oneTimeTransaction;
  }

  /**
   * This is a one-time transaction and not part of a subscription.
   * @param oneTimeTransaction oneTimeTransaction or {@code null} for none
   */
  public ExternalTransaction setOneTimeTransaction(OneTimeExternalTransaction oneTimeTransaction) {
    this.oneTimeTransaction = oneTimeTransaction;
    return this;
  }

  /**
   * Required. The original transaction amount before taxes. This represents the pre-tax amount
   * originally notified to Google before any refunds were applied.
   * @return value or {@code null} for none
   */
  public Price getOriginalPreTaxAmount() {
    return originalPreTaxAmount;
  }

  /**
   * Required. The original transaction amount before taxes. This represents the pre-tax amount
   * originally notified to Google before any refunds were applied.
   * @param originalPreTaxAmount originalPreTaxAmount or {@code null} for none
   */
  public ExternalTransaction setOriginalPreTaxAmount(Price originalPreTaxAmount) {
    this.originalPreTaxAmount = originalPreTaxAmount;
    return this;
  }

  /**
   * Required. The original tax amount. This represents the tax amount originally notified to Google
   * before any refunds were applied.
   * @return value or {@code null} for none
   */
  public Price getOriginalTaxAmount() {
    return originalTaxAmount;
  }

  /**
   * Required. The original tax amount. This represents the tax amount originally notified to Google
   * before any refunds were applied.
   * @param originalTaxAmount originalTaxAmount or {@code null} for none
   */
  public ExternalTransaction setOriginalTaxAmount(Price originalTaxAmount) {
    this.originalTaxAmount = originalTaxAmount;
    return this;
  }

  /**
   * Output only. The resource name of the external transaction. The package name of the application
   * the inapp products were sold (for example, 'com.some.app').
   * @return value or {@code null} for none
   */
  public java.lang.String getPackageName() {
    return packageName;
  }

  /**
   * Output only. The resource name of the external transaction. The package name of the application
   * the inapp products were sold (for example, 'com.some.app').
   * @param packageName packageName or {@code null} for none
   */
  public ExternalTransaction setPackageName(java.lang.String packageName) {
    this.packageName = packageName;
    return this;
  }

  /**
   * This transaction is part of a recurring series of transactions.
   * @return value or {@code null} for none
   */
  public RecurringExternalTransaction getRecurringTransaction() {
    return recurringTransaction;
  }

  /**
   * This transaction is part of a recurring series of transactions.
   * @param recurringTransaction recurringTransaction or {@code null} for none
   */
  public ExternalTransaction setRecurringTransaction(RecurringExternalTransaction recurringTransaction) {
    this.recurringTransaction = recurringTransaction;
    return this;
  }

  /**
   * Output only. If set, this transaction was a test purchase. Google will not charge for a test
   * transaction.
   * @return value or {@code null} for none
   */
  public ExternalTransactionTestPurchase getTestPurchase() {
    return testPurchase;
  }

  /**
   * Output only. If set, this transaction was a test purchase. Google will not charge for a test
   * transaction.
   * @param testPurchase testPurchase or {@code null} for none
   */
  public ExternalTransaction setTestPurchase(ExternalTransactionTestPurchase testPurchase) {
    this.testPurchase = testPurchase;
    return this;
  }

  /**
   * Output only. The current state of the transaction.
   * @return value or {@code null} for none
   */
  public java.lang.String getTransactionState() {
    return transactionState;
  }

  /**
   * Output only. The current state of the transaction.
   * @param transactionState transactionState or {@code null} for none
   */
  public ExternalTransaction setTransactionState(java.lang.String transactionState) {
    this.transactionState = transactionState;
    return this;
  }

  /**
   * Required. The time when the transaction was completed.
   * @return value or {@code null} for none
   */
  public String getTransactionTime() {
    return transactionTime;
  }

  /**
   * Required. The time when the transaction was completed.
   * @param transactionTime transactionTime or {@code null} for none
   */
  public ExternalTransaction setTransactionTime(String transactionTime) {
    this.transactionTime = transactionTime;
    return this;
  }

  /**
   * Required. User address for tax computation.
   * @return value or {@code null} for none
   */
  public ExternalTransactionAddress getUserTaxAddress() {
    return userTaxAddress;
  }

  /**
   * Required. User address for tax computation.
   * @param userTaxAddress userTaxAddress or {@code null} for none
   */
  public ExternalTransaction setUserTaxAddress(ExternalTransactionAddress userTaxAddress) {
    this.userTaxAddress = userTaxAddress;
    return this;
  }

  @Override
  public ExternalTransaction set(String fieldName, Object value) {
    return (ExternalTransaction) super.set(fieldName, value);
  }

  @Override
  public ExternalTransaction clone() {
    return (ExternalTransaction) super.clone();
  }

}
