/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Data format for a continuous range of app versions.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AppVersionRange extends com.google.api.client.json.GenericJson {

  /**
   * Highest app version in the range, inclusive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long versionCodeEnd;

  /**
   * Lowest app version in the range, inclusive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long versionCodeStart;

  /**
   * Highest app version in the range, inclusive.
   * @return value or {@code null} for none
   */
  public java.lang.Long getVersionCodeEnd() {
    return versionCodeEnd;
  }

  /**
   * Highest app version in the range, inclusive.
   * @param versionCodeEnd versionCodeEnd or {@code null} for none
   */
  public AppVersionRange setVersionCodeEnd(java.lang.Long versionCodeEnd) {
    this.versionCodeEnd = versionCodeEnd;
    return this;
  }

  /**
   * Lowest app version in the range, inclusive.
   * @return value or {@code null} for none
   */
  public java.lang.Long getVersionCodeStart() {
    return versionCodeStart;
  }

  /**
   * Lowest app version in the range, inclusive.
   * @param versionCodeStart versionCodeStart or {@code null} for none
   */
  public AppVersionRange setVersionCodeStart(java.lang.Long versionCodeStart) {
    this.versionCodeStart = versionCodeStart;
    return this;
  }

  @Override
  public AppVersionRange set(String fieldName, Object value) {
    return (AppVersionRange) super.set(fieldName, value);
  }

  @Override
  public AppVersionRange clone() {
    return (AppVersionRange) super.clone();
  }

}
