/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Request to update Safety Labels of an app.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SafetyLabelsUpdateRequest extends com.google.api.client.json.GenericJson {

  /**
   * Required. Contents of the CSV file containing Data Safety responses. For the format of this
   * file, see the Help Center documentation at https://support.google.com/googleplay/android-
   * developer/answer/10787469?hl=en#zippy=%2Cunderstand-the-csv-format To download an up to date
   * template, follow the steps at https://support.google.com/googleplay/android-
   * developer/answer/10787469?hl=en#zippy=%2Cexport-to-a-csv-file
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String safetyLabels;

  /**
   * Required. Contents of the CSV file containing Data Safety responses. For the format of this
   * file, see the Help Center documentation at https://support.google.com/googleplay/android-
   * developer/answer/10787469?hl=en#zippy=%2Cunderstand-the-csv-format To download an up to date
   * template, follow the steps at https://support.google.com/googleplay/android-
   * developer/answer/10787469?hl=en#zippy=%2Cexport-to-a-csv-file
   * @return value or {@code null} for none
   */
  public java.lang.String getSafetyLabels() {
    return safetyLabels;
  }

  /**
   * Required. Contents of the CSV file containing Data Safety responses. For the format of this
   * file, see the Help Center documentation at https://support.google.com/googleplay/android-
   * developer/answer/10787469?hl=en#zippy=%2Cunderstand-the-csv-format To download an up to date
   * template, follow the steps at https://support.google.com/googleplay/android-
   * developer/answer/10787469?hl=en#zippy=%2Cexport-to-a-csv-file
   * @param safetyLabels safetyLabels or {@code null} for none
   */
  public SafetyLabelsUpdateRequest setSafetyLabels(java.lang.String safetyLabels) {
    this.safetyLabels = safetyLabels;
    return this;
  }

  @Override
  public SafetyLabelsUpdateRequest set(String fieldName, Object value) {
    return (SafetyLabelsUpdateRequest) super.set(fieldName, value);
  }

  @Override
  public SafetyLabelsUpdateRequest clone() {
    return (SafetyLabelsUpdateRequest) super.clone();
  }

}
