/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Information about an app recovery action.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AppRecoveryAction extends com.google.api.client.json.GenericJson {

  /**
   * ID corresponding to the app recovery action.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long appRecoveryId;

  /**
   * Timestamp of when the app recovery action is canceled by the developer. Only set if the
   * recovery action has been canceled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String cancelTime;

  /**
   * Timestamp of when the app recovery action is created by the developer. It is always set after
   * creation of the recovery action.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * Timestamp of when the app recovery action is deployed to the users. Only set if the recovery
   * action has been deployed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String deployTime;

  /**
   * Timestamp of when the developer last updated recovery action. In case the action is cancelled,
   * it corresponds to cancellation time. It is always set after creation of the recovery action.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String lastUpdateTime;

  /**
   * Data about the remote in-app update action such as such as recovered user base, recoverable
   * user base etc. Set only if the recovery action type is Remote In-App Update.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RemoteInAppUpdateData remoteInAppUpdateData;

  /**
   * The status of the recovery action.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * Specifies targeting criteria for the recovery action such as regions, android sdk versions, app
   * versions etc.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Targeting targeting;

  /**
   * ID corresponding to the app recovery action.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAppRecoveryId() {
    return appRecoveryId;
  }

  /**
   * ID corresponding to the app recovery action.
   * @param appRecoveryId appRecoveryId or {@code null} for none
   */
  public AppRecoveryAction setAppRecoveryId(java.lang.Long appRecoveryId) {
    this.appRecoveryId = appRecoveryId;
    return this;
  }

  /**
   * Timestamp of when the app recovery action is canceled by the developer. Only set if the
   * recovery action has been canceled.
   * @return value or {@code null} for none
   */
  public String getCancelTime() {
    return cancelTime;
  }

  /**
   * Timestamp of when the app recovery action is canceled by the developer. Only set if the
   * recovery action has been canceled.
   * @param cancelTime cancelTime or {@code null} for none
   */
  public AppRecoveryAction setCancelTime(String cancelTime) {
    this.cancelTime = cancelTime;
    return this;
  }

  /**
   * Timestamp of when the app recovery action is created by the developer. It is always set after
   * creation of the recovery action.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * Timestamp of when the app recovery action is created by the developer. It is always set after
   * creation of the recovery action.
   * @param createTime createTime or {@code null} for none
   */
  public AppRecoveryAction setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * Timestamp of when the app recovery action is deployed to the users. Only set if the recovery
   * action has been deployed.
   * @return value or {@code null} for none
   */
  public String getDeployTime() {
    return deployTime;
  }

  /**
   * Timestamp of when the app recovery action is deployed to the users. Only set if the recovery
   * action has been deployed.
   * @param deployTime deployTime or {@code null} for none
   */
  public AppRecoveryAction setDeployTime(String deployTime) {
    this.deployTime = deployTime;
    return this;
  }

  /**
   * Timestamp of when the developer last updated recovery action. In case the action is cancelled,
   * it corresponds to cancellation time. It is always set after creation of the recovery action.
   * @return value or {@code null} for none
   */
  public String getLastUpdateTime() {
    return lastUpdateTime;
  }

  /**
   * Timestamp of when the developer last updated recovery action. In case the action is cancelled,
   * it corresponds to cancellation time. It is always set after creation of the recovery action.
   * @param lastUpdateTime lastUpdateTime or {@code null} for none
   */
  public AppRecoveryAction setLastUpdateTime(String lastUpdateTime) {
    this.lastUpdateTime = lastUpdateTime;
    return this;
  }

  /**
   * Data about the remote in-app update action such as such as recovered user base, recoverable
   * user base etc. Set only if the recovery action type is Remote In-App Update.
   * @return value or {@code null} for none
   */
  public RemoteInAppUpdateData getRemoteInAppUpdateData() {
    return remoteInAppUpdateData;
  }

  /**
   * Data about the remote in-app update action such as such as recovered user base, recoverable
   * user base etc. Set only if the recovery action type is Remote In-App Update.
   * @param remoteInAppUpdateData remoteInAppUpdateData or {@code null} for none
   */
  public AppRecoveryAction setRemoteInAppUpdateData(RemoteInAppUpdateData remoteInAppUpdateData) {
    this.remoteInAppUpdateData = remoteInAppUpdateData;
    return this;
  }

  /**
   * The status of the recovery action.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * The status of the recovery action.
   * @param status status or {@code null} for none
   */
  public AppRecoveryAction setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  /**
   * Specifies targeting criteria for the recovery action such as regions, android sdk versions, app
   * versions etc.
   * @return value or {@code null} for none
   */
  public Targeting getTargeting() {
    return targeting;
  }

  /**
   * Specifies targeting criteria for the recovery action such as regions, android sdk versions, app
   * versions etc.
   * @param targeting targeting or {@code null} for none
   */
  public AppRecoveryAction setTargeting(Targeting targeting) {
    this.targeting = targeting;
    return this;
  }

  @Override
  public AppRecoveryAction set(String fieldName, Object value) {
    return (AppRecoveryAction) super.set(fieldName, value);
  }

  @Override
  public AppRecoveryAction clone() {
    return (AppRecoveryAction) super.clone();
  }

}
