/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Targeting by a texture compression format.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TextureCompressionFormatTargeting extends com.google.api.client.json.GenericJson {

  /**
   * List of alternative TCFs (TCFs targeted by the sibling splits).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TextureCompressionFormat> alternatives;

  static {
    // hack to force ProGuard to consider TextureCompressionFormat used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(TextureCompressionFormat.class);
  }

  /**
   * The list of targeted TCFs. Should not be empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TextureCompressionFormat> value;

  static {
    // hack to force ProGuard to consider TextureCompressionFormat used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(TextureCompressionFormat.class);
  }

  /**
   * List of alternative TCFs (TCFs targeted by the sibling splits).
   * @return value or {@code null} for none
   */
  public java.util.List<TextureCompressionFormat> getAlternatives() {
    return alternatives;
  }

  /**
   * List of alternative TCFs (TCFs targeted by the sibling splits).
   * @param alternatives alternatives or {@code null} for none
   */
  public TextureCompressionFormatTargeting setAlternatives(java.util.List<TextureCompressionFormat> alternatives) {
    this.alternatives = alternatives;
    return this;
  }

  /**
   * The list of targeted TCFs. Should not be empty.
   * @return value or {@code null} for none
   */
  public java.util.List<TextureCompressionFormat> getValue() {
    return value;
  }

  /**
   * The list of targeted TCFs. Should not be empty.
   * @param value value or {@code null} for none
   */
  public TextureCompressionFormatTargeting setValue(java.util.List<TextureCompressionFormat> value) {
    this.value = value;
    return this;
  }

  @Override
  public TextureCompressionFormatTargeting set(String fieldName, Object value) {
    return (TextureCompressionFormatTargeting) super.set(fieldName, value);
  }

  @Override
  public TextureCompressionFormatTargeting clone() {
    return (TextureCompressionFormatTargeting) super.clone();
  }

}
