/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * An access grant resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Grant extends com.google.api.client.json.GenericJson {

  /**
   * The permissions granted to the user for this app.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> appLevelPermissions;

  /**
   * Required. Resource name for this grant, following the pattern
   * "developers/{developer}/users/{email}/grants/{package_name}". If this grant is for a draft app,
   * the app ID will be used in this resource name instead of the package name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Immutable. The package name of the app. This will be empty for draft apps.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String packageName;

  /**
   * The permissions granted to the user for this app.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getAppLevelPermissions() {
    return appLevelPermissions;
  }

  /**
   * The permissions granted to the user for this app.
   * @param appLevelPermissions appLevelPermissions or {@code null} for none
   */
  public Grant setAppLevelPermissions(java.util.List<java.lang.String> appLevelPermissions) {
    this.appLevelPermissions = appLevelPermissions;
    return this;
  }

  /**
   * Required. Resource name for this grant, following the pattern
   * "developers/{developer}/users/{email}/grants/{package_name}". If this grant is for a draft app,
   * the app ID will be used in this resource name instead of the package name.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Required. Resource name for this grant, following the pattern
   * "developers/{developer}/users/{email}/grants/{package_name}". If this grant is for a draft app,
   * the app ID will be used in this resource name instead of the package name.
   * @param name name or {@code null} for none
   */
  public Grant setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Immutable. The package name of the app. This will be empty for draft apps.
   * @return value or {@code null} for none
   */
  public java.lang.String getPackageName() {
    return packageName;
  }

  /**
   * Immutable. The package name of the app. This will be empty for draft apps.
   * @param packageName packageName or {@code null} for none
   */
  public Grant setPackageName(java.lang.String packageName) {
    this.packageName = packageName;
    return this;
  }

  @Override
  public Grant set(String fieldName, Object value) {
    return (Grant) super.set(fieldName, value);
  }

  @Override
  public Grant clone() {
    return (Grant) super.clone();
  }

}
