/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Android api level targeting data for app recovery action targeting.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AndroidSdks extends com.google.api.client.json.GenericJson {

  /**
   * Android api levels of devices targeted by recovery action. See
   * https://developer.android.com/guide/topics/manifest/uses-sdk-element#ApiLevels for different
   * api levels in android.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.util.List<java.lang.Long> sdkLevels;

  /**
   * Android api levels of devices targeted by recovery action. See
   * https://developer.android.com/guide/topics/manifest/uses-sdk-element#ApiLevels for different
   * api levels in android.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Long> getSdkLevels() {
    return sdkLevels;
  }

  /**
   * Android api levels of devices targeted by recovery action. See
   * https://developer.android.com/guide/topics/manifest/uses-sdk-element#ApiLevels for different
   * api levels in android.
   * @param sdkLevels sdkLevels or {@code null} for none
   */
  public AndroidSdks setSdkLevels(java.util.List<java.lang.Long> sdkLevels) {
    this.sdkLevels = sdkLevels;
    return this;
  }

  @Override
  public AndroidSdks set(String fieldName, Object value) {
    return (AndroidSdks) super.set(fieldName, value);
  }

  @Override
  public AndroidSdks clone() {
    return (AndroidSdks) super.clone();
  }

}
