/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Targeting information about the generated apks.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TargetingInfo extends com.google.api.client.json.GenericJson {

  /**
   * List of created asset slices.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AssetSliceSet> assetSliceSet;

  static {
    // hack to force ProGuard to consider AssetSliceSet used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(AssetSliceSet.class);
  }

  /**
   * The package name of this app.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String packageName;

  /**
   * List of the created variants.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<SplitApkVariant> variant;

  static {
    // hack to force ProGuard to consider SplitApkVariant used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(SplitApkVariant.class);
  }

  /**
   * List of created asset slices.
   * @return value or {@code null} for none
   */
  public java.util.List<AssetSliceSet> getAssetSliceSet() {
    return assetSliceSet;
  }

  /**
   * List of created asset slices.
   * @param assetSliceSet assetSliceSet or {@code null} for none
   */
  public TargetingInfo setAssetSliceSet(java.util.List<AssetSliceSet> assetSliceSet) {
    this.assetSliceSet = assetSliceSet;
    return this;
  }

  /**
   * The package name of this app.
   * @return value or {@code null} for none
   */
  public java.lang.String getPackageName() {
    return packageName;
  }

  /**
   * The package name of this app.
   * @param packageName packageName or {@code null} for none
   */
  public TargetingInfo setPackageName(java.lang.String packageName) {
    this.packageName = packageName;
    return this;
  }

  /**
   * List of the created variants.
   * @return value or {@code null} for none
   */
  public java.util.List<SplitApkVariant> getVariant() {
    return variant;
  }

  /**
   * List of the created variants.
   * @param variant variant or {@code null} for none
   */
  public TargetingInfo setVariant(java.util.List<SplitApkVariant> variant) {
    this.variant = variant;
    return this;
  }

  @Override
  public TargetingInfo set(String fieldName, Object value) {
    return (TargetingInfo) super.set(fieldName, value);
  }

  @Override
  public TargetingInfo clone() {
    return (TargetingInfo) super.clone();
  }

}
