/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * A set of user countries. A country set determines what variation of app content gets served to a
 * specific location.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UserCountrySet extends com.google.api.client.json.GenericJson {

  /**
   * List of country codes representing countries. A Country code is represented in ISO 3166 alpha-2
   * format. For Example:- "IT" for Italy, "GE" for Georgia.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> countryCodes;

  /**
   * Country set name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * List of country codes representing countries. A Country code is represented in ISO 3166 alpha-2
   * format. For Example:- "IT" for Italy, "GE" for Georgia.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getCountryCodes() {
    return countryCodes;
  }

  /**
   * List of country codes representing countries. A Country code is represented in ISO 3166 alpha-2
   * format. For Example:- "IT" for Italy, "GE" for Georgia.
   * @param countryCodes countryCodes or {@code null} for none
   */
  public UserCountrySet setCountryCodes(java.util.List<java.lang.String> countryCodes) {
    this.countryCodes = countryCodes;
    return this;
  }

  /**
   * Country set name.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Country set name.
   * @param name name or {@code null} for none
   */
  public UserCountrySet setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public UserCountrySet set(String fieldName, Object value) {
    return (UserCountrySet) super.set(fieldName, value);
  }

  @Override
  public UserCountrySet clone() {
    return (UserCountrySet) super.clone();
  }

}
