/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Represents a transaction that is part of a recurring series of payments. This can be a
 * subscription or a one-time product with multiple payments (such as preorder).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RecurringExternalTransaction extends com.google.api.client.json.GenericJson {

  /**
   * Details of an external subscription.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ExternalSubscription externalSubscription;

  /**
   * Input only. Provided during the call to Create. Retrieved from the client when the alternative
   * billing flow is launched. Required only for the initial purchase.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String externalTransactionToken;

  /**
   * The external transaction id of the first transaction of this recurring series of transactions.
   * For example, for a subscription this would be the transaction id of the first payment. Required
   * when creating recurring external transactions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String initialExternalTransactionId;

  /**
   * Input only. Provided during the call to Create. Must only be used when migrating a subscription
   * from manual monthly reporting to automated reporting.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String migratedTransactionProgram;

  /**
   * Details of an external subscription.
   * @return value or {@code null} for none
   */
  public ExternalSubscription getExternalSubscription() {
    return externalSubscription;
  }

  /**
   * Details of an external subscription.
   * @param externalSubscription externalSubscription or {@code null} for none
   */
  public RecurringExternalTransaction setExternalSubscription(ExternalSubscription externalSubscription) {
    this.externalSubscription = externalSubscription;
    return this;
  }

  /**
   * Input only. Provided during the call to Create. Retrieved from the client when the alternative
   * billing flow is launched. Required only for the initial purchase.
   * @return value or {@code null} for none
   */
  public java.lang.String getExternalTransactionToken() {
    return externalTransactionToken;
  }

  /**
   * Input only. Provided during the call to Create. Retrieved from the client when the alternative
   * billing flow is launched. Required only for the initial purchase.
   * @param externalTransactionToken externalTransactionToken or {@code null} for none
   */
  public RecurringExternalTransaction setExternalTransactionToken(java.lang.String externalTransactionToken) {
    this.externalTransactionToken = externalTransactionToken;
    return this;
  }

  /**
   * The external transaction id of the first transaction of this recurring series of transactions.
   * For example, for a subscription this would be the transaction id of the first payment. Required
   * when creating recurring external transactions.
   * @return value or {@code null} for none
   */
  public java.lang.String getInitialExternalTransactionId() {
    return initialExternalTransactionId;
  }

  /**
   * The external transaction id of the first transaction of this recurring series of transactions.
   * For example, for a subscription this would be the transaction id of the first payment. Required
   * when creating recurring external transactions.
   * @param initialExternalTransactionId initialExternalTransactionId or {@code null} for none
   */
  public RecurringExternalTransaction setInitialExternalTransactionId(java.lang.String initialExternalTransactionId) {
    this.initialExternalTransactionId = initialExternalTransactionId;
    return this;
  }

  /**
   * Input only. Provided during the call to Create. Must only be used when migrating a subscription
   * from manual monthly reporting to automated reporting.
   * @return value or {@code null} for none
   */
  public java.lang.String getMigratedTransactionProgram() {
    return migratedTransactionProgram;
  }

  /**
   * Input only. Provided during the call to Create. Must only be used when migrating a subscription
   * from manual monthly reporting to automated reporting.
   * @param migratedTransactionProgram migratedTransactionProgram or {@code null} for none
   */
  public RecurringExternalTransaction setMigratedTransactionProgram(java.lang.String migratedTransactionProgram) {
    this.migratedTransactionProgram = migratedTransactionProgram;
    return this;
  }

  @Override
  public RecurringExternalTransaction set(String fieldName, Object value) {
    return (RecurringExternalTransaction) super.set(fieldName, value);
  }

  @Override
  public RecurringExternalTransaction clone() {
    return (RecurringExternalTransaction) super.clone();
  }

}
