/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * User account identifier in the third-party service.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ExternalAccountIdentifiers extends com.google.api.client.json.GenericJson {

  /**
   * User account identifier in the third-party service. Only present if account linking happened as
   * part of the subscription purchase flow.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String externalAccountId;

  /**
   * An obfuscated version of the id that is uniquely associated with the user's account in your
   * app. Present for the following purchases: * If account linking happened as part of the
   * subscription purchase flow. * It was specified using https://developer.android.com/reference/co
   * m/android/billingclient/api/BillingFlowParams.Builder#setobfuscatedaccountid when the purchase
   * was made.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String obfuscatedExternalAccountId;

  /**
   * An obfuscated version of the id that is uniquely associated with the user's profile in your
   * app. Only present if specified using https://developer.android.com/reference/com/android/billin
   * gclient/api/BillingFlowParams.Builder#setobfuscatedprofileid when the purchase was made.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String obfuscatedExternalProfileId;

  /**
   * User account identifier in the third-party service. Only present if account linking happened as
   * part of the subscription purchase flow.
   * @return value or {@code null} for none
   */
  public java.lang.String getExternalAccountId() {
    return externalAccountId;
  }

  /**
   * User account identifier in the third-party service. Only present if account linking happened as
   * part of the subscription purchase flow.
   * @param externalAccountId externalAccountId or {@code null} for none
   */
  public ExternalAccountIdentifiers setExternalAccountId(java.lang.String externalAccountId) {
    this.externalAccountId = externalAccountId;
    return this;
  }

  /**
   * An obfuscated version of the id that is uniquely associated with the user's account in your
   * app. Present for the following purchases: * If account linking happened as part of the
   * subscription purchase flow. * It was specified using https://developer.android.com/reference/co
   * m/android/billingclient/api/BillingFlowParams.Builder#setobfuscatedaccountid when the purchase
   * was made.
   * @return value or {@code null} for none
   */
  public java.lang.String getObfuscatedExternalAccountId() {
    return obfuscatedExternalAccountId;
  }

  /**
   * An obfuscated version of the id that is uniquely associated with the user's account in your
   * app. Present for the following purchases: * If account linking happened as part of the
   * subscription purchase flow. * It was specified using https://developer.android.com/reference/co
   * m/android/billingclient/api/BillingFlowParams.Builder#setobfuscatedaccountid when the purchase
   * was made.
   * @param obfuscatedExternalAccountId obfuscatedExternalAccountId or {@code null} for none
   */
  public ExternalAccountIdentifiers setObfuscatedExternalAccountId(java.lang.String obfuscatedExternalAccountId) {
    this.obfuscatedExternalAccountId = obfuscatedExternalAccountId;
    return this;
  }

  /**
   * An obfuscated version of the id that is uniquely associated with the user's profile in your
   * app. Only present if specified using https://developer.android.com/reference/com/android/billin
   * gclient/api/BillingFlowParams.Builder#setobfuscatedprofileid when the purchase was made.
   * @return value or {@code null} for none
   */
  public java.lang.String getObfuscatedExternalProfileId() {
    return obfuscatedExternalProfileId;
  }

  /**
   * An obfuscated version of the id that is uniquely associated with the user's profile in your
   * app. Only present if specified using https://developer.android.com/reference/com/android/billin
   * gclient/api/BillingFlowParams.Builder#setobfuscatedprofileid when the purchase was made.
   * @param obfuscatedExternalProfileId obfuscatedExternalProfileId or {@code null} for none
   */
  public ExternalAccountIdentifiers setObfuscatedExternalProfileId(java.lang.String obfuscatedExternalProfileId) {
    this.obfuscatedExternalProfileId = obfuscatedExternalProfileId;
    return this;
  }

  @Override
  public ExternalAccountIdentifiers set(String fieldName, Object value) {
    return (ExternalAccountIdentifiers) super.set(fieldName, value);
  }

  @Override
  public ExternalAccountIdentifiers clone() {
    return (ExternalAccountIdentifiers) super.clone();
  }

}
