/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Targeting on the module level.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ModuleTargeting extends com.google.api.client.json.GenericJson {

  /**
   * Targeting for device features.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DeviceFeatureTargeting> deviceFeatureTargeting;

  static {
    // hack to force ProGuard to consider DeviceFeatureTargeting used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(DeviceFeatureTargeting.class);
  }

  /**
   * The sdk version that the variant targets
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SdkVersionTargeting sdkVersionTargeting;

  /**
   * Countries-level targeting
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UserCountriesTargeting userCountriesTargeting;

  /**
   * Targeting for device features.
   * @return value or {@code null} for none
   */
  public java.util.List<DeviceFeatureTargeting> getDeviceFeatureTargeting() {
    return deviceFeatureTargeting;
  }

  /**
   * Targeting for device features.
   * @param deviceFeatureTargeting deviceFeatureTargeting or {@code null} for none
   */
  public ModuleTargeting setDeviceFeatureTargeting(java.util.List<DeviceFeatureTargeting> deviceFeatureTargeting) {
    this.deviceFeatureTargeting = deviceFeatureTargeting;
    return this;
  }

  /**
   * The sdk version that the variant targets
   * @return value or {@code null} for none
   */
  public SdkVersionTargeting getSdkVersionTargeting() {
    return sdkVersionTargeting;
  }

  /**
   * The sdk version that the variant targets
   * @param sdkVersionTargeting sdkVersionTargeting or {@code null} for none
   */
  public ModuleTargeting setSdkVersionTargeting(SdkVersionTargeting sdkVersionTargeting) {
    this.sdkVersionTargeting = sdkVersionTargeting;
    return this;
  }

  /**
   * Countries-level targeting
   * @return value or {@code null} for none
   */
  public UserCountriesTargeting getUserCountriesTargeting() {
    return userCountriesTargeting;
  }

  /**
   * Countries-level targeting
   * @param userCountriesTargeting userCountriesTargeting or {@code null} for none
   */
  public ModuleTargeting setUserCountriesTargeting(UserCountriesTargeting userCountriesTargeting) {
    this.userCountriesTargeting = userCountriesTargeting;
    return this;
  }

  @Override
  public ModuleTargeting set(String fieldName, Object value) {
    return (ModuleTargeting) super.set(fieldName, value);
  }

  @Override
  public ModuleTargeting clone() {
    return (ModuleTargeting) super.clone();
  }

}
