/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * A partial refund of a transaction.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PartialRefund extends com.google.api.client.json.GenericJson {

  /**
   * Required. A unique id distinguishing this partial refund. If the refund is successful,
   * subsequent refunds with the same id will fail. Must be unique across refunds for one individual
   * transaction.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String refundId;

  /**
   * Required. The pre-tax amount of the partial refund. Should be less than the remaining pre-tax
   * amount of the transaction.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price refundPreTaxAmount;

  /**
   * Required. A unique id distinguishing this partial refund. If the refund is successful,
   * subsequent refunds with the same id will fail. Must be unique across refunds for one individual
   * transaction.
   * @return value or {@code null} for none
   */
  public java.lang.String getRefundId() {
    return refundId;
  }

  /**
   * Required. A unique id distinguishing this partial refund. If the refund is successful,
   * subsequent refunds with the same id will fail. Must be unique across refunds for one individual
   * transaction.
   * @param refundId refundId or {@code null} for none
   */
  public PartialRefund setRefundId(java.lang.String refundId) {
    this.refundId = refundId;
    return this;
  }

  /**
   * Required. The pre-tax amount of the partial refund. Should be less than the remaining pre-tax
   * amount of the transaction.
   * @return value or {@code null} for none
   */
  public Price getRefundPreTaxAmount() {
    return refundPreTaxAmount;
  }

  /**
   * Required. The pre-tax amount of the partial refund. Should be less than the remaining pre-tax
   * amount of the transaction.
   * @param refundPreTaxAmount refundPreTaxAmount or {@code null} for none
   */
  public PartialRefund setRefundPreTaxAmount(Price refundPreTaxAmount) {
    this.refundPreTaxAmount = refundPreTaxAmount;
    return this;
  }

  @Override
  public PartialRefund set(String fieldName, Object value) {
    return (PartialRefund) super.set(fieldName, value);
  }

  @Override
  public PartialRefund clone() {
    return (PartialRefund) super.clone();
  }

}
