/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Targeting based on screen density.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ScreenDensityTargeting extends com.google.api.client.json.GenericJson {

  /**
   * Targeting of other sibling directories that were in the Bundle. For main splits this is
   * targeting of other main splits.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ScreenDensity> alternatives;

  static {
    // hack to force ProGuard to consider ScreenDensity used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ScreenDensity.class);
  }

  /**
   * Value of a screen density.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ScreenDensity> value;

  static {
    // hack to force ProGuard to consider ScreenDensity used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ScreenDensity.class);
  }

  /**
   * Targeting of other sibling directories that were in the Bundle. For main splits this is
   * targeting of other main splits.
   * @return value or {@code null} for none
   */
  public java.util.List<ScreenDensity> getAlternatives() {
    return alternatives;
  }

  /**
   * Targeting of other sibling directories that were in the Bundle. For main splits this is
   * targeting of other main splits.
   * @param alternatives alternatives or {@code null} for none
   */
  public ScreenDensityTargeting setAlternatives(java.util.List<ScreenDensity> alternatives) {
    this.alternatives = alternatives;
    return this;
  }

  /**
   * Value of a screen density.
   * @return value or {@code null} for none
   */
  public java.util.List<ScreenDensity> getValue() {
    return value;
  }

  /**
   * Value of a screen density.
   * @param value value or {@code null} for none
   */
  public ScreenDensityTargeting setValue(java.util.List<ScreenDensity> value) {
    this.value = value;
    return this;
  }

  @Override
  public ScreenDensityTargeting set(String fieldName, Object value) {
    return (ScreenDensityTargeting) super.set(fieldName, value);
  }

  @Override
  public ScreenDensityTargeting clone() {
    return (ScreenDensityTargeting) super.clone();
  }

}
