/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Represents a screen density.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ScreenDensity extends com.google.api.client.json.GenericJson {

  /**
   * Alias for a screen density.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String densityAlias;

  /**
   * Value for density dpi.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer densityDpi;

  /**
   * Alias for a screen density.
   * @return value or {@code null} for none
   */
  public java.lang.String getDensityAlias() {
    return densityAlias;
  }

  /**
   * Alias for a screen density.
   * @param densityAlias densityAlias or {@code null} for none
   */
  public ScreenDensity setDensityAlias(java.lang.String densityAlias) {
    this.densityAlias = densityAlias;
    return this;
  }

  /**
   * Value for density dpi.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getDensityDpi() {
    return densityDpi;
  }

  /**
   * Value for density dpi.
   * @param densityDpi densityDpi or {@code null} for none
   */
  public ScreenDensity setDensityDpi(java.lang.Integer densityDpi) {
    this.densityDpi = densityDpi;
    return this;
  }

  @Override
  public ScreenDensity set(String fieldName, Object value) {
    return (ScreenDensity) super.set(fieldName, value);
  }

  @Override
  public ScreenDensity clone() {
    return (ScreenDensity) super.clone();
  }

}
