/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Targeting based on sdk version.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SdkVersionTargeting extends com.google.api.client.json.GenericJson {

  /**
   * Targeting of other sibling directories that were in the Bundle. For main splits this is
   * targeting of other main splits.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<SdkVersion> alternatives;

  static {
    // hack to force ProGuard to consider SdkVersion used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(SdkVersion.class);
  }

  /**
   * Value of an sdk version.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<SdkVersion> value;

  static {
    // hack to force ProGuard to consider SdkVersion used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(SdkVersion.class);
  }

  /**
   * Targeting of other sibling directories that were in the Bundle. For main splits this is
   * targeting of other main splits.
   * @return value or {@code null} for none
   */
  public java.util.List<SdkVersion> getAlternatives() {
    return alternatives;
  }

  /**
   * Targeting of other sibling directories that were in the Bundle. For main splits this is
   * targeting of other main splits.
   * @param alternatives alternatives or {@code null} for none
   */
  public SdkVersionTargeting setAlternatives(java.util.List<SdkVersion> alternatives) {
    this.alternatives = alternatives;
    return this;
  }

  /**
   * Value of an sdk version.
   * @return value or {@code null} for none
   */
  public java.util.List<SdkVersion> getValue() {
    return value;
  }

  /**
   * Value of an sdk version.
   * @param value value or {@code null} for none
   */
  public SdkVersionTargeting setValue(java.util.List<SdkVersion> value) {
    this.value = value;
    return this;
  }

  @Override
  public SdkVersionTargeting set(String fieldName, Object value) {
    return (SdkVersionTargeting) super.set(fieldName, value);
  }

  @Override
  public SdkVersionTargeting clone() {
    return (SdkVersionTargeting) super.clone();
  }

}
