/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * A track configuration. The resource for TracksService.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Track extends com.google.api.client.json.GenericJson {

  /**
   * In a read request, represents all active releases in the track. In an update request,
   * represents desired changes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TrackRelease> releases;

  /**
   * Identifier of the track. Form factor tracks have a special prefix as an identifier, for example
   * `wear:production`, `automotive:production`. [More on track name](https://developers.google.com
   * /android-publisher/tracks#ff-track-name)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String track;

  /**
   * In a read request, represents all active releases in the track. In an update request,
   * represents desired changes.
   * @return value or {@code null} for none
   */
  public java.util.List<TrackRelease> getReleases() {
    return releases;
  }

  /**
   * In a read request, represents all active releases in the track. In an update request,
   * represents desired changes.
   * @param releases releases or {@code null} for none
   */
  public Track setReleases(java.util.List<TrackRelease> releases) {
    this.releases = releases;
    return this;
  }

  /**
   * Identifier of the track. Form factor tracks have a special prefix as an identifier, for example
   * `wear:production`, `automotive:production`. [More on track name](https://developers.google.com
   * /android-publisher/tracks#ff-track-name)
   * @return value or {@code null} for none
   */
  public java.lang.String getTrack() {
    return track;
  }

  /**
   * Identifier of the track. Form factor tracks have a special prefix as an identifier, for example
   * `wear:production`, `automotive:production`. [More on track name](https://developers.google.com
   * /android-publisher/tracks#ff-track-name)
   * @param track track or {@code null} for none
   */
  public Track setTrack(java.lang.String track) {
    this.track = track;
    return this;
  }

  @Override
  public Track set(String fieldName, Object value) {
    return (Track) super.set(fieldName, value);
  }

  @Override
  public Track clone() {
    return (Track) super.clone();
  }

}
