/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Describes an inclusive/exclusive list of country codes that module targets.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UserCountriesTargeting extends com.google.api.client.json.GenericJson {

  /**
   * List of country codes in the two-letter CLDR territory format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> countryCodes;

  /**
   * Indicates if the list above is exclusive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean exclude;

  /**
   * List of country codes in the two-letter CLDR territory format.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getCountryCodes() {
    return countryCodes;
  }

  /**
   * List of country codes in the two-letter CLDR territory format.
   * @param countryCodes countryCodes or {@code null} for none
   */
  public UserCountriesTargeting setCountryCodes(java.util.List<java.lang.String> countryCodes) {
    this.countryCodes = countryCodes;
    return this;
  }

  /**
   * Indicates if the list above is exclusive.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getExclude() {
    return exclude;
  }

  /**
   * Indicates if the list above is exclusive.
   * @param exclude exclude or {@code null} for none
   */
  public UserCountriesTargeting setExclude(java.lang.Boolean exclude) {
    this.exclude = exclude;
    return this;
  }

  @Override
  public UserCountriesTargeting set(String fieldName, Object value) {
    return (UserCountriesTargeting) super.set(fieldName, value);
  }

  @Override
  public UserCountriesTargeting clone() {
    return (UserCountriesTargeting) super.clone();
  }

}
