/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Request message to update the state of a subscription base plan.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpdateBasePlanStateRequest extends com.google.api.client.json.GenericJson {

  /**
   * Activates a base plan. Once activated, base plans will be available to new subscribers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ActivateBasePlanRequest activateBasePlanRequest;

  /**
   * Deactivates a base plan. Once deactivated, the base plan will become unavailable to new
   * subscribers, but existing subscribers will maintain their subscription
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeactivateBasePlanRequest deactivateBasePlanRequest;

  /**
   * Activates a base plan. Once activated, base plans will be available to new subscribers.
   * @return value or {@code null} for none
   */
  public ActivateBasePlanRequest getActivateBasePlanRequest() {
    return activateBasePlanRequest;
  }

  /**
   * Activates a base plan. Once activated, base plans will be available to new subscribers.
   * @param activateBasePlanRequest activateBasePlanRequest or {@code null} for none
   */
  public UpdateBasePlanStateRequest setActivateBasePlanRequest(ActivateBasePlanRequest activateBasePlanRequest) {
    this.activateBasePlanRequest = activateBasePlanRequest;
    return this;
  }

  /**
   * Deactivates a base plan. Once deactivated, the base plan will become unavailable to new
   * subscribers, but existing subscribers will maintain their subscription
   * @return value or {@code null} for none
   */
  public DeactivateBasePlanRequest getDeactivateBasePlanRequest() {
    return deactivateBasePlanRequest;
  }

  /**
   * Deactivates a base plan. Once deactivated, the base plan will become unavailable to new
   * subscribers, but existing subscribers will maintain their subscription
   * @param deactivateBasePlanRequest deactivateBasePlanRequest or {@code null} for none
   */
  public UpdateBasePlanStateRequest setDeactivateBasePlanRequest(DeactivateBasePlanRequest deactivateBasePlanRequest) {
    this.deactivateBasePlanRequest = deactivateBasePlanRequest;
    return this;
  }

  @Override
  public UpdateBasePlanStateRequest set(String fieldName, Object value) {
    return (UpdateBasePlanStateRequest) super.set(fieldName, value);
  }

  @Override
  public UpdateBasePlanStateRequest clone() {
    return (UpdateBasePlanStateRequest) super.clone();
  }

}
