/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Countries where the purchase of this product is restricted to payment methods registered in the
 * same country. If empty, no payment location restrictions are imposed.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RestrictedPaymentCountries extends com.google.api.client.json.GenericJson {

  /**
   * Required. Region codes to impose payment restrictions on, as defined by ISO 3166-2, e.g. "US".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> regionCodes;

  /**
   * Required. Region codes to impose payment restrictions on, as defined by ISO 3166-2, e.g. "US".
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getRegionCodes() {
    return regionCodes;
  }

  /**
   * Required. Region codes to impose payment restrictions on, as defined by ISO 3166-2, e.g. "US".
   * @param regionCodes regionCodes or {@code null} for none
   */
  public RestrictedPaymentCountries setRegionCodes(java.util.List<java.lang.String> regionCodes) {
    this.regionCodes = regionCodes;
    return this;
  }

  @Override
  public RestrictedPaymentCountries set(String fieldName, Object value) {
    return (RestrictedPaymentCountries) super.set(fieldName, value);
  }

  @Override
  public RestrictedPaymentCountries clone() {
    return (RestrictedPaymentCountries) super.clone();
  }

}
