/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * A set of apks representing a module.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ApkSet extends com.google.api.client.json.GenericJson {

  /**
   * Description of the generated apks.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ApkDescription> apkDescription;

  static {
    // hack to force ProGuard to consider ApkDescription used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ApkDescription.class);
  }

  /**
   * Metadata about the module represented by this ApkSet
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ModuleMetadata moduleMetadata;

  /**
   * Description of the generated apks.
   * @return value or {@code null} for none
   */
  public java.util.List<ApkDescription> getApkDescription() {
    return apkDescription;
  }

  /**
   * Description of the generated apks.
   * @param apkDescription apkDescription or {@code null} for none
   */
  public ApkSet setApkDescription(java.util.List<ApkDescription> apkDescription) {
    this.apkDescription = apkDescription;
    return this;
  }

  /**
   * Metadata about the module represented by this ApkSet
   * @return value or {@code null} for none
   */
  public ModuleMetadata getModuleMetadata() {
    return moduleMetadata;
  }

  /**
   * Metadata about the module represented by this ApkSet
   * @param moduleMetadata moduleMetadata or {@code null} for none
   */
  public ApkSet setModuleMetadata(ModuleMetadata moduleMetadata) {
    this.moduleMetadata = moduleMetadata;
    return this;
  }

  @Override
  public ApkSet set(String fieldName, Object value) {
    return (ApkSet) super.set(fieldName, value);
  }

  @Override
  public ApkSet clone() {
    return (ApkSet) super.clone();
  }

}
