/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * A converted region price.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ConvertedRegionPrice extends com.google.api.client.json.GenericJson {

  /**
   * The converted price tax inclusive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Money price;

  /**
   * The region code of the region.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String regionCode;

  /**
   * The tax amount of the converted price.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Money taxAmount;

  /**
   * The converted price tax inclusive.
   * @return value or {@code null} for none
   */
  public Money getPrice() {
    return price;
  }

  /**
   * The converted price tax inclusive.
   * @param price price or {@code null} for none
   */
  public ConvertedRegionPrice setPrice(Money price) {
    this.price = price;
    return this;
  }

  /**
   * The region code of the region.
   * @return value or {@code null} for none
   */
  public java.lang.String getRegionCode() {
    return regionCode;
  }

  /**
   * The region code of the region.
   * @param regionCode regionCode or {@code null} for none
   */
  public ConvertedRegionPrice setRegionCode(java.lang.String regionCode) {
    this.regionCode = regionCode;
    return this;
  }

  /**
   * The tax amount of the converted price.
   * @return value or {@code null} for none
   */
  public Money getTaxAmount() {
    return taxAmount;
  }

  /**
   * The tax amount of the converted price.
   * @param taxAmount taxAmount or {@code null} for none
   */
  public ConvertedRegionPrice setTaxAmount(Money taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

  @Override
  public ConvertedRegionPrice set(String fieldName, Object value) {
    return (ConvertedRegionPrice) super.set(fieldName, value);
  }

  @Override
  public ConvertedRegionPrice clone() {
    return (ConvertedRegionPrice) super.clone();
  }

}
