/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Request message for CreateDraftAppRecovery.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CreateDraftAppRecoveryRequest extends com.google.api.client.json.GenericJson {

  /**
   * Action type is remote in-app update. As a consequence of this action, a downloadable recovery
   * module is also created for testing purposes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RemoteInAppUpdate remoteInAppUpdate;

  /**
   * Specifies targeting criteria for the recovery action such as regions, android sdk versions, app
   * versions etc.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Targeting targeting;

  /**
   * Action type is remote in-app update. As a consequence of this action, a downloadable recovery
   * module is also created for testing purposes.
   * @return value or {@code null} for none
   */
  public RemoteInAppUpdate getRemoteInAppUpdate() {
    return remoteInAppUpdate;
  }

  /**
   * Action type is remote in-app update. As a consequence of this action, a downloadable recovery
   * module is also created for testing purposes.
   * @param remoteInAppUpdate remoteInAppUpdate or {@code null} for none
   */
  public CreateDraftAppRecoveryRequest setRemoteInAppUpdate(RemoteInAppUpdate remoteInAppUpdate) {
    this.remoteInAppUpdate = remoteInAppUpdate;
    return this;
  }

  /**
   * Specifies targeting criteria for the recovery action such as regions, android sdk versions, app
   * versions etc.
   * @return value or {@code null} for none
   */
  public Targeting getTargeting() {
    return targeting;
  }

  /**
   * Specifies targeting criteria for the recovery action such as regions, android sdk versions, app
   * versions etc.
   * @param targeting targeting or {@code null} for none
   */
  public CreateDraftAppRecoveryRequest setTargeting(Targeting targeting) {
    this.targeting = targeting;
    return this;
  }

  @Override
  public CreateDraftAppRecoveryRequest set(String fieldName, Object value) {
    return (CreateDraftAppRecoveryRequest) super.set(fieldName, value);
  }

  @Override
  public CreateDraftAppRecoveryRequest clone() {
    return (CreateDraftAppRecoveryRequest) super.clone();
  }

}
