/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Response to list generated APKs.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GeneratedApksListResponse extends com.google.api.client.json.GenericJson {

  /**
   * All generated APKs, grouped by the APK signing key.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GeneratedApksPerSigningKey> generatedApks;

  /**
   * All generated APKs, grouped by the APK signing key.
   * @return value or {@code null} for none
   */
  public java.util.List<GeneratedApksPerSigningKey> getGeneratedApks() {
    return generatedApks;
  }

  /**
   * All generated APKs, grouped by the APK signing key.
   * @param generatedApks generatedApks or {@code null} for none
   */
  public GeneratedApksListResponse setGeneratedApks(java.util.List<GeneratedApksPerSigningKey> generatedApks) {
    this.generatedApks = generatedApks;
    return this;
  }

  @Override
  public GeneratedApksListResponse set(String fieldName, Object value) {
    return (GeneratedApksListResponse) super.set(fieldName, value);
  }

  @Override
  public GeneratedApksListResponse clone() {
    return (GeneratedApksListResponse) super.clone();
  }

}
