/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Download metadata for an asset pack slice.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GeneratedAssetPackSlice extends com.google.api.client.json.GenericJson {

  /**
   * Download ID, which uniquely identifies the APK to download. Should be supplied to
   * `generatedapks.download` method.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String downloadId;

  /**
   * Name of the module that this asset slice belongs to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String moduleName;

  /**
   * Asset slice ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sliceId;

  /**
   * Asset module version.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long version;

  /**
   * Download ID, which uniquely identifies the APK to download. Should be supplied to
   * `generatedapks.download` method.
   * @return value or {@code null} for none
   */
  public java.lang.String getDownloadId() {
    return downloadId;
  }

  /**
   * Download ID, which uniquely identifies the APK to download. Should be supplied to
   * `generatedapks.download` method.
   * @param downloadId downloadId or {@code null} for none
   */
  public GeneratedAssetPackSlice setDownloadId(java.lang.String downloadId) {
    this.downloadId = downloadId;
    return this;
  }

  /**
   * Name of the module that this asset slice belongs to.
   * @return value or {@code null} for none
   */
  public java.lang.String getModuleName() {
    return moduleName;
  }

  /**
   * Name of the module that this asset slice belongs to.
   * @param moduleName moduleName or {@code null} for none
   */
  public GeneratedAssetPackSlice setModuleName(java.lang.String moduleName) {
    this.moduleName = moduleName;
    return this;
  }

  /**
   * Asset slice ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getSliceId() {
    return sliceId;
  }

  /**
   * Asset slice ID.
   * @param sliceId sliceId or {@code null} for none
   */
  public GeneratedAssetPackSlice setSliceId(java.lang.String sliceId) {
    this.sliceId = sliceId;
    return this;
  }

  /**
   * Asset module version.
   * @return value or {@code null} for none
   */
  public java.lang.Long getVersion() {
    return version;
  }

  /**
   * Asset module version.
   * @param version version or {@code null} for none
   */
  public GeneratedAssetPackSlice setVersion(java.lang.Long version) {
    this.version = version;
    return this;
  }

  @Override
  public GeneratedAssetPackSlice set(String fieldName, Object value) {
    return (GeneratedAssetPackSlice) super.set(fieldName, value);
  }

  @Override
  public GeneratedAssetPackSlice clone() {
    return (GeneratedAssetPackSlice) super.clone();
  }

}
