/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Request to delete an in-app product.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InappproductsDeleteRequest extends com.google.api.client.json.GenericJson {

  /**
   * Optional. The latency tolerance for the propagation of this product update. Defaults to
   * latency-sensitive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String latencyTolerance;

  /**
   * Package name of the app.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String packageName;

  /**
   * Unique identifier for the in-app product.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sku;

  /**
   * Optional. The latency tolerance for the propagation of this product update. Defaults to
   * latency-sensitive.
   * @return value or {@code null} for none
   */
  public java.lang.String getLatencyTolerance() {
    return latencyTolerance;
  }

  /**
   * Optional. The latency tolerance for the propagation of this product update. Defaults to
   * latency-sensitive.
   * @param latencyTolerance latencyTolerance or {@code null} for none
   */
  public InappproductsDeleteRequest setLatencyTolerance(java.lang.String latencyTolerance) {
    this.latencyTolerance = latencyTolerance;
    return this;
  }

  /**
   * Package name of the app.
   * @return value or {@code null} for none
   */
  public java.lang.String getPackageName() {
    return packageName;
  }

  /**
   * Package name of the app.
   * @param packageName packageName or {@code null} for none
   */
  public InappproductsDeleteRequest setPackageName(java.lang.String packageName) {
    this.packageName = packageName;
    return this;
  }

  /**
   * Unique identifier for the in-app product.
   * @return value or {@code null} for none
   */
  public java.lang.String getSku() {
    return sku;
  }

  /**
   * Unique identifier for the in-app product.
   * @param sku sku or {@code null} for none
   */
  public InappproductsDeleteRequest setSku(java.lang.String sku) {
    this.sku = sku;
    return this;
  }

  @Override
  public InappproductsDeleteRequest set(String fieldName, Object value) {
    return (InappproductsDeleteRequest) super.set(fieldName, value);
  }

  @Override
  public InappproductsDeleteRequest clone() {
    return (InappproductsDeleteRequest) super.clone();
  }

}
