/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Configuration for a price migration.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RegionalPriceMigrationConfig extends com.google.api.client.json.GenericJson {

  /**
   * Required. The cutoff time for historical prices that subscribers can remain paying. Subscribers
   * on prices which were available at this cutoff time or later will stay on their existing price.
   * Subscribers on older prices will be migrated to the currently-offered price. The migrated
   * subscribers will receive a notification that they will be paying a different price. Subscribers
   * who do not agree to the new price will have their subscription ended at the next renewal.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String oldestAllowedPriceVersionTime;

  /**
   * Optional. The behavior the caller wants users to see when there is a price increase during
   * migration. If left unset, the behavior defaults to PRICE_INCREASE_TYPE_OPT_IN. Note that the
   * first opt-out price increase migration for each app must be initiated in Play Console.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String priceIncreaseType;

  /**
   * Required. Region code this configuration applies to, as defined by ISO 3166-2, e.g. "US".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String regionCode;

  /**
   * Required. The cutoff time for historical prices that subscribers can remain paying. Subscribers
   * on prices which were available at this cutoff time or later will stay on their existing price.
   * Subscribers on older prices will be migrated to the currently-offered price. The migrated
   * subscribers will receive a notification that they will be paying a different price. Subscribers
   * who do not agree to the new price will have their subscription ended at the next renewal.
   * @return value or {@code null} for none
   */
  public String getOldestAllowedPriceVersionTime() {
    return oldestAllowedPriceVersionTime;
  }

  /**
   * Required. The cutoff time for historical prices that subscribers can remain paying. Subscribers
   * on prices which were available at this cutoff time or later will stay on their existing price.
   * Subscribers on older prices will be migrated to the currently-offered price. The migrated
   * subscribers will receive a notification that they will be paying a different price. Subscribers
   * who do not agree to the new price will have their subscription ended at the next renewal.
   * @param oldestAllowedPriceVersionTime oldestAllowedPriceVersionTime or {@code null} for none
   */
  public RegionalPriceMigrationConfig setOldestAllowedPriceVersionTime(String oldestAllowedPriceVersionTime) {
    this.oldestAllowedPriceVersionTime = oldestAllowedPriceVersionTime;
    return this;
  }

  /**
   * Optional. The behavior the caller wants users to see when there is a price increase during
   * migration. If left unset, the behavior defaults to PRICE_INCREASE_TYPE_OPT_IN. Note that the
   * first opt-out price increase migration for each app must be initiated in Play Console.
   * @return value or {@code null} for none
   */
  public java.lang.String getPriceIncreaseType() {
    return priceIncreaseType;
  }

  /**
   * Optional. The behavior the caller wants users to see when there is a price increase during
   * migration. If left unset, the behavior defaults to PRICE_INCREASE_TYPE_OPT_IN. Note that the
   * first opt-out price increase migration for each app must be initiated in Play Console.
   * @param priceIncreaseType priceIncreaseType or {@code null} for none
   */
  public RegionalPriceMigrationConfig setPriceIncreaseType(java.lang.String priceIncreaseType) {
    this.priceIncreaseType = priceIncreaseType;
    return this;
  }

  /**
   * Required. Region code this configuration applies to, as defined by ISO 3166-2, e.g. "US".
   * @return value or {@code null} for none
   */
  public java.lang.String getRegionCode() {
    return regionCode;
  }

  /**
   * Required. Region code this configuration applies to, as defined by ISO 3166-2, e.g. "US".
   * @param regionCode regionCode or {@code null} for none
   */
  public RegionalPriceMigrationConfig setRegionCode(java.lang.String regionCode) {
    this.regionCode = regionCode;
    return this;
  }

  @Override
  public RegionalPriceMigrationConfig set(String fieldName, Object value) {
    return (RegionalPriceMigrationConfig) super.set(fieldName, value);
  }

  @Override
  public RegionalPriceMigrationConfig clone() {
    return (RegionalPriceMigrationConfig) super.clone();
  }

}
