/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Holds data specific to Split APKs.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SplitApkMetadata extends com.google.api.client.json.GenericJson {

  /**
   * Indicates whether this APK is the main split of the module.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isMasterSplit;

  /**
   * Id of the split.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String splitId;

  /**
   * Indicates whether this APK is the main split of the module.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsMasterSplit() {
    return isMasterSplit;
  }

  /**
   * Indicates whether this APK is the main split of the module.
   * @param isMasterSplit isMasterSplit or {@code null} for none
   */
  public SplitApkMetadata setIsMasterSplit(java.lang.Boolean isMasterSplit) {
    this.isMasterSplit = isMasterSplit;
    return this;
  }

  /**
   * Id of the split.
   * @return value or {@code null} for none
   */
  public java.lang.String getSplitId() {
    return splitId;
  }

  /**
   * Id of the split.
   * @param splitId splitId or {@code null} for none
   */
  public SplitApkMetadata setSplitId(java.lang.String splitId) {
    this.splitId = splitId;
    return this;
  }

  @Override
  public SplitApkMetadata set(String fieldName, Object value) {
    return (SplitApkMetadata) super.set(fieldName, value);
  }

  @Override
  public SplitApkMetadata clone() {
    return (SplitApkMetadata) super.clone();
  }

}
