/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * The consumer-visible metadata of a subscription.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SubscriptionListing extends com.google.api.client.json.GenericJson {

  /**
   * A list of benefits shown to the user on platforms such as the Play Store and in restoration
   * flows in the language of this listing. Plain text. Ordered list of at most four benefits.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> benefits;

  /**
   * The description of this subscription in the language of this listing. Maximum length - 80
   * characters. Plain text.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Required. The language of this listing, as defined by BCP-47, e.g. "en-US".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String languageCode;

  /**
   * Required. The title of this subscription in the language of this listing. Plain text.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * A list of benefits shown to the user on platforms such as the Play Store and in restoration
   * flows in the language of this listing. Plain text. Ordered list of at most four benefits.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getBenefits() {
    return benefits;
  }

  /**
   * A list of benefits shown to the user on platforms such as the Play Store and in restoration
   * flows in the language of this listing. Plain text. Ordered list of at most four benefits.
   * @param benefits benefits or {@code null} for none
   */
  public SubscriptionListing setBenefits(java.util.List<java.lang.String> benefits) {
    this.benefits = benefits;
    return this;
  }

  /**
   * The description of this subscription in the language of this listing. Maximum length - 80
   * characters. Plain text.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * The description of this subscription in the language of this listing. Maximum length - 80
   * characters. Plain text.
   * @param description description or {@code null} for none
   */
  public SubscriptionListing setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Required. The language of this listing, as defined by BCP-47, e.g. "en-US".
   * @return value or {@code null} for none
   */
  public java.lang.String getLanguageCode() {
    return languageCode;
  }

  /**
   * Required. The language of this listing, as defined by BCP-47, e.g. "en-US".
   * @param languageCode languageCode or {@code null} for none
   */
  public SubscriptionListing setLanguageCode(java.lang.String languageCode) {
    this.languageCode = languageCode;
    return this;
  }

  /**
   * Required. The title of this subscription in the language of this listing. Plain text.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * Required. The title of this subscription in the language of this listing. Plain text.
   * @param title title or {@code null} for none
   */
  public SubscriptionListing setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  @Override
  public SubscriptionListing set(String fieldName, Object value) {
    return (SubscriptionListing) super.set(fieldName, value);
  }

  @Override
  public SubscriptionListing clone() {
    return (SubscriptionListing) super.clone();
  }

}
