/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Update type for targeting. Note it is always a subset Targeting.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TargetingUpdate extends com.google.api.client.json.GenericJson {

  /**
   * All users are targeted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AllUsers allUsers;

  /**
   * Additional android sdk levels are targeted by the recovery action.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AndroidSdks androidSdks;

  /**
   * Additional regions are targeted by the recovery action.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Regions regions;

  /**
   * All users are targeted.
   * @return value or {@code null} for none
   */
  public AllUsers getAllUsers() {
    return allUsers;
  }

  /**
   * All users are targeted.
   * @param allUsers allUsers or {@code null} for none
   */
  public TargetingUpdate setAllUsers(AllUsers allUsers) {
    this.allUsers = allUsers;
    return this;
  }

  /**
   * Additional android sdk levels are targeted by the recovery action.
   * @return value or {@code null} for none
   */
  public AndroidSdks getAndroidSdks() {
    return androidSdks;
  }

  /**
   * Additional android sdk levels are targeted by the recovery action.
   * @param androidSdks androidSdks or {@code null} for none
   */
  public TargetingUpdate setAndroidSdks(AndroidSdks androidSdks) {
    this.androidSdks = androidSdks;
    return this;
  }

  /**
   * Additional regions are targeted by the recovery action.
   * @return value or {@code null} for none
   */
  public Regions getRegions() {
    return regions;
  }

  /**
   * Additional regions are targeted by the recovery action.
   * @param regions regions or {@code null} for none
   */
  public TargetingUpdate setRegions(Regions regions) {
    this.regions = regions;
    return this;
  }

  @Override
  public TargetingUpdate set(String fieldName, Object value) {
    return (TargetingUpdate) super.set(fieldName, value);
  }

  @Override
  public TargetingUpdate clone() {
    return (TargetingUpdate) super.clone();
  }

}
