/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Configurations of the new track.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TrackConfig extends com.google.api.client.json.GenericJson {

  /**
   * Required. Form factor of the new track. Defaults to the default track.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String formFactor;

  /**
   * Required. Identifier of the new track. For default tracks, this field consists of the track
   * alias only. Form factor tracks have a special prefix as an identifier, for example
   * `wear:production`, `automotive:production`. This prefix must match the value of the
   * `form_factor` field, if it is not a default track. [More on track
   * name](https://developers.google.com/android-publisher/tracks#ff-track-name)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String track;

  /**
   * Required. Type of the new track. Currently, the only supported value is closedTesting.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Required. Form factor of the new track. Defaults to the default track.
   * @return value or {@code null} for none
   */
  public java.lang.String getFormFactor() {
    return formFactor;
  }

  /**
   * Required. Form factor of the new track. Defaults to the default track.
   * @param formFactor formFactor or {@code null} for none
   */
  public TrackConfig setFormFactor(java.lang.String formFactor) {
    this.formFactor = formFactor;
    return this;
  }

  /**
   * Required. Identifier of the new track. For default tracks, this field consists of the track
   * alias only. Form factor tracks have a special prefix as an identifier, for example
   * `wear:production`, `automotive:production`. This prefix must match the value of the
   * `form_factor` field, if it is not a default track. [More on track
   * name](https://developers.google.com/android-publisher/tracks#ff-track-name)
   * @return value or {@code null} for none
   */
  public java.lang.String getTrack() {
    return track;
  }

  /**
   * Required. Identifier of the new track. For default tracks, this field consists of the track
   * alias only. Form factor tracks have a special prefix as an identifier, for example
   * `wear:production`, `automotive:production`. This prefix must match the value of the
   * `form_factor` field, if it is not a default track. [More on track
   * name](https://developers.google.com/android-publisher/tracks#ff-track-name)
   * @param track track or {@code null} for none
   */
  public TrackConfig setTrack(java.lang.String track) {
    this.track = track;
    return this;
  }

  /**
   * Required. Type of the new track. Currently, the only supported value is closedTesting.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Required. Type of the new track. Currently, the only supported value is closedTesting.
   * @param type type or {@code null} for none
   */
  public TrackConfig setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public TrackConfig set(String fieldName, Object value) {
    return (TrackConfig) super.set(fieldName, value);
  }

  @Override
  public TrackConfig clone() {
    return (TrackConfig) super.clone();
  }

}
