/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.androidpublisher.model;

/**
 * Request to update an in-app product.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Android Developer API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InappproductsUpdateRequest extends com.google.api.client.json.GenericJson {

  /**
   * If set to true, and the in-app product with the given package_name and sku doesn't exist, the
   * in-app product will be created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean allowMissing;

  /**
   * If true the prices for all regions targeted by the parent app that don't have a price specified
   * for this in-app product will be auto converted to the target currency based on the default
   * price. Defaults to false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean autoConvertMissingPrices;

  /**
   * The new in-app product.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InAppProduct inappproduct;

  /**
   * Optional. The latency tolerance for the propagation of this product update. Defaults to
   * latency-sensitive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String latencyTolerance;

  /**
   * Package name of the app.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String packageName;

  /**
   * Unique identifier for the in-app product.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sku;

  /**
   * If set to true, and the in-app product with the given package_name and sku doesn't exist, the
   * in-app product will be created.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAllowMissing() {
    return allowMissing;
  }

  /**
   * If set to true, and the in-app product with the given package_name and sku doesn't exist, the
   * in-app product will be created.
   * @param allowMissing allowMissing or {@code null} for none
   */
  public InappproductsUpdateRequest setAllowMissing(java.lang.Boolean allowMissing) {
    this.allowMissing = allowMissing;
    return this;
  }

  /**
   * If true the prices for all regions targeted by the parent app that don't have a price specified
   * for this in-app product will be auto converted to the target currency based on the default
   * price. Defaults to false.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAutoConvertMissingPrices() {
    return autoConvertMissingPrices;
  }

  /**
   * If true the prices for all regions targeted by the parent app that don't have a price specified
   * for this in-app product will be auto converted to the target currency based on the default
   * price. Defaults to false.
   * @param autoConvertMissingPrices autoConvertMissingPrices or {@code null} for none
   */
  public InappproductsUpdateRequest setAutoConvertMissingPrices(java.lang.Boolean autoConvertMissingPrices) {
    this.autoConvertMissingPrices = autoConvertMissingPrices;
    return this;
  }

  /**
   * The new in-app product.
   * @return value or {@code null} for none
   */
  public InAppProduct getInappproduct() {
    return inappproduct;
  }

  /**
   * The new in-app product.
   * @param inappproduct inappproduct or {@code null} for none
   */
  public InappproductsUpdateRequest setInappproduct(InAppProduct inappproduct) {
    this.inappproduct = inappproduct;
    return this;
  }

  /**
   * Optional. The latency tolerance for the propagation of this product update. Defaults to
   * latency-sensitive.
   * @return value or {@code null} for none
   */
  public java.lang.String getLatencyTolerance() {
    return latencyTolerance;
  }

  /**
   * Optional. The latency tolerance for the propagation of this product update. Defaults to
   * latency-sensitive.
   * @param latencyTolerance latencyTolerance or {@code null} for none
   */
  public InappproductsUpdateRequest setLatencyTolerance(java.lang.String latencyTolerance) {
    this.latencyTolerance = latencyTolerance;
    return this;
  }

  /**
   * Package name of the app.
   * @return value or {@code null} for none
   */
  public java.lang.String getPackageName() {
    return packageName;
  }

  /**
   * Package name of the app.
   * @param packageName packageName or {@code null} for none
   */
  public InappproductsUpdateRequest setPackageName(java.lang.String packageName) {
    this.packageName = packageName;
    return this;
  }

  /**
   * Unique identifier for the in-app product.
   * @return value or {@code null} for none
   */
  public java.lang.String getSku() {
    return sku;
  }

  /**
   * Unique identifier for the in-app product.
   * @param sku sku or {@code null} for none
   */
  public InappproductsUpdateRequest setSku(java.lang.String sku) {
    this.sku = sku;
    return this;
  }

  @Override
  public InappproductsUpdateRequest set(String fieldName, Object value) {
    return (InappproductsUpdateRequest) super.set(fieldName, value);
  }

  @Override
  public InappproductsUpdateRequest clone() {
    return (InappproductsUpdateRequest) super.clone();
  }

}
